<?php
namespace App\Controller;

use App\Controller\AppController;
use Cake\Datasource\ConnectionManager;
use PDOException;
/**
 * VotacaoFetems Controller
 *
 * @property \App\Model\Table\VotacaoFetemsTable $VotacaoFetems
 *
 * @method \App\Model\Entity\VotacaoFetem[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class VotacaoFetemsController extends AppController
{
    /**
     * Add method
     *
     * @return \Cake\Http\Response|null Redirects on successful add, renders view otherwise.
     */
    public function add($usuario = null, $chapa_fetems_selecionada = null)
    {
        $this->loadModel('Filiado');
        $this->loadModel('Chapasfetems');
        $this->loadModel('Configuracao');

        $config = $this->Configuracao->buscarDataHoraVotacao();
        if(!$config->periodo_votacao){
            $this->viewBuilder()->layout('ajax');
            $this->autoRender = false;
            $res = ['controller' => 'filiado', 'action' => 'error', 'dentro_periodo' => false];
            return $this->response->withType('json')->withStringBody(json_encode($res));
        }

        $connection = ConnectionManager::get('default');

        $this->Filiado->setConnection($connection);
        $this->Chapasfetems->setConnection($connection);

        $connection->begin();

        try {
            if(empty($this->request->getSession()->read('filiado'))){
                throw new PDOException('Sessão expirada ou não foi iniciada! Por favor faça login.', 0);
            }
    
            $filiado_votou_todos = $this->Filiado->filiadoVotouDthoraIp($usuario, 'VotacaoFetems');

            if(!empty($filiado_votou_todos) && $filiado_votou_todos->votou == 1){
                throw new PDOException('Seus votos já foi realizado em '.date('d/m/Y', strtotime($filiado_votou_todos->votou_dthora)).' as '.date('H:i:s', strtotime($filiado_votou_todos->votou_dthora)).' pelo IP '.$filiado_votou_todos->votacao_fetems->ip, 1);
            }
            
            $filiado_votou_fetems = $this->VotacaoFetems->find('all')->where(['filiado_id' => json_decode(base64_decode($usuario))->id])->first();
            
            if(!empty($filiado_votou_fetems)){
                throw new PDOException('Seu voto já foi realizado', 2);
            }
    
            $cidade_id = $this->Filiado->getCidadeId($usuario);
            if(empty($cidade_id)) {
                throw new PDOException('Filiado não encontrado no sistema. Por favor, faça login.', 1);
            }
            
            $chapasFetems = $this->Chapasfetems
            ->find('all')
            ->where(['lista_votacao' => 1]);

            $chapasfetems = $chapasFetems->toArray();
            
            $votacaoFetem = $this->VotacaoFetems->newEntity();
            if ($this->request->is('post')) {
                $this->viewBuilder()->layout('ajax');
                $this->autoRender = false;
                $res = ['msg' => 'Voto Fetems realizado com sucesso', 'exists' => false, 'controller' => 'filiado', 'dentro_periodo' => true];
                
                $usuario = json_decode(base64_decode($usuario))->id;
                
                if($this->VotacaoFetems->find('list')->where(['filiado_id' => $usuario])->toArray() != []){    
                    $res['msg'] = 'Este item já foi votado! Não é possível refazer o voto.';
                    $res['exists'] = true;
                    return $this->response->withType('json')->withStringBody(json_encode($res));
                }
    
                $votacaoFetem = $this->VotacaoFetems->patchEntity($votacaoFetem, $this->request->getData());
                $votacaoFetem->filiado_id = intval($usuario);
                $votacaoFetem->chapasfetems_id = (int) $chapa_fetems_selecionada;
                $votacaoFetem->dthora = date('Y-m-d H:i:s');
                $votacaoFetem->votacao_concluida = 1;
                $votacaoFetem->ip = $_SERVER['REMOTE_ADDR'];
                if(!$this->VotacaoFetems->save($votacaoFetem)){
                    throw new PDOException('Falha ao salvar votação FETEMS');
                }
                $connection->commit();
                return $this->response->withType('json')->withStringBody(json_encode($res));
            } 
        } catch (PDOException $e) {
            $connection->rollback();

            $usuario_proxima_pagina = '';

            if($e->getCode() == 0){
                $controller = 'filiado';
                $action = 'index';
            } else if($e->getCode() == 1) {
                $controller = '/';
                $action = 'index';
            } else if($e->getCode() == 2) {
                $controller = 'votacao-chapasregionais';
                $action = 'add';
                $usuario_proxima_pagina = $usuario;
            }

            $this->Flash->error(__($e->getMessage()));
            $this->redirect(['controller' => '/', 'action' => 'index']);
        }  
        
        $this->set(compact('chapasfetems', 'cidade_id', 'usuario'));
    }
    
}
