<?php
namespace App\Controller;

use App\Controller\AppController;

/**
 * Sindicato Controller
 *
 * @property \App\Model\Table\SindicatoTable $Sindicato
 *
 * @method \App\Model\Entity\Sindicato[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class SindicatoController extends AppController
{
    /**
     * Index method
     *
     * @return \Cake\Http\Response|null
     */
    public function index()
    {
        $this->paginate = [
            'contain' => ['Cidade'],
        ];
        $sindicato = $this->paginate($this->Sindicato);

        $this->set(compact('sindicato'));
    }

    /**
     * View method
     *
     * @param string|null $id Sindicato id.
     * @return \Cake\Http\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $sindicato = $this->Sindicato->get($id, [
            'contain' => ['Cidade', 'Filiado'],
        ]);

        $this->set('sindicato', $sindicato);
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $sindicato = $this->Sindicato->newEntity();
        if ($this->request->is('post')) {
            $sindicato = $this->Sindicato->patchEntity($sindicato, $this->request->getData());
            if ($this->Sindicato->save($sindicato)) {
                $this->Flash->success(__('The sindicato has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The sindicato could not be saved. Please, try again.'));
        }
        $cidade = $this->Sindicato->Cidade->find('list', ['limit' => 200]);
        $this->set(compact('sindicato', 'cidade'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Sindicato id.
     * @return \Cake\Http\Response|null Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $sindicato = $this->Sindicato->get($id, [
            'contain' => [],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $sindicato = $this->Sindicato->patchEntity($sindicato, $this->request->getData());
            if ($this->Sindicato->save($sindicato)) {
                $this->Flash->success(__('The sindicato has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The sindicato could not be saved. Please, try again.'));
        }
        $cidade = $this->Sindicato->Cidade->find('list', ['limit' => 200]);
        $this->set(compact('sindicato', 'cidade'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Sindicato id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $sindicato = $this->Sindicato->get($id);
        if ($this->Sindicato->delete($sindicato)) {
            $this->Flash->success(__('The sindicato has been deleted.'));
        } else {
            $this->Flash->error(__('The sindicato could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }

    public function fill($id = null)
    {
        $this->viewBuilder()->layout('ajax');
        $this->autoRender = false;

        $sindicato = $this->Sindicato->find()->where(['cidade_id' => $id])->order(['nome' => 'ASC'])->toArray();

        foreach ($sindicato as $s) {
            $ret["dados"][] = array('id' => $s->id, 'text' => $s->nome);
        }

        return $this->response->withStringBody(json_encode($ret));
    }
}
