<?php
use Migrations\AbstractMigration;

class CreateTabelaChapasFetems extends AbstractMigration
{
    /**
     * Change Method.
     *
     * More information on this method is available here:
     * https://book.cakephp.org/phinx/0/en/migrations.html#the-change-method
     * @return void
     */
    public function change()
    {

        if (!$this->hasTable('chapasfetems')) {
            $table = $this->table('chapasfetems');
            
            $table->addColumn('nome', 'string', ['null' => true]);
            $table->addColumn('lista_votacao', 'integer', ['null' => true, 'comment' => '0 - NÃO | 1 - SIM', 'default' => 1]);
            
            $table->create();

            $this->insert('chapasfetems', [
                'id' => -1,
                'nome' => 'Voto Branco',
                'lista_votacao' => 0
            ]);
        }

    }
}
