<?php

/**
 * CakePHP(tm) : Rapid Development Framework (https://cakephp.org)
 * Copyright (c) Cake Software Foundation, Inc. (https://cakefoundation.org)
 *
 * Licensed under The MIT License
 * For full copyright and license information, please see the LICENSE.txt
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright     Copyright (c) Cake Software Foundation, Inc. (https://cakefoundation.org)
 * @link          https://cakephp.org CakePHP(tm) Project
 * @since         0.10.0
 * @license       https://opensource.org/licenses/mit-license.php MIT License
 * @var \App\View\AppView $this
 */

$cakeDescription = 'Fetems - Votação';
?>
<!DOCTYPE html>
<html>

<head>
    <?= $this->Html->charset() ?>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>
        <?= $cakeDescription ?>:
        <?= $this->fetch('title') ?>
    </title>
    <?= $this->Html->meta('icon') ?>

    <?= $this->Html->css('base.css') ?>
    <?= $this->Html->css('bootstrap.min.css') ?>
    <?= $this->Html->css('step-by-step.css') ?>
    <?= $this->Html->css('green.css') ?>
    <?= $this->Html->css('style.css') ?>
    <?= $this->Html->script('jquery-2.1.1.js') ?>
    <?= $this->Html->script('functions') ?>

    <?= $this->fetch('meta') ?>
    <?= $this->fetch('css') ?>
    <?= $this->fetch('script') ?>
</head>

<body>
    <nav class="top-bar expanded" data-topbar role="navigation">
        <ul class="title-area large-5 medium-6 columns">
            <li class="name">
                <a href="/votacao" style="text-decoration: none">
                    <h1 class="text-light fs-4">SINTEDE Campo Grande - 2022/2026 </h1>
                </a>
            </li>
        </ul>
    </nav>
    <?= $this->Flash->render() ?>
    <div class="position-fixed top-0 end-0 p-2" style="z-index: 5">
        <div id="liveToast" class="toast fade hide" role="alert" aria-live="assertive" aria-atomic="true">
            <div class="toast-header">
                <img class="rounded me-2" alt="X" width="20" />
                <strong class="me-auto" style="font-size: 15px">ERRO</strong>
            </div>
            <div class="toast-body" style="font-size: 15px"></div>
        </div>
    </div>
    <div class="container clearfix">
        <input type="hidden" name="_csrfToken" value="<?= $this->request->getParam('_csrfToken'); ?>" />
        <?= $this->fetch('content') ?>
    </div>
    <footer>
        <?php
        $root = strstr(ROOT, 'public_html');
        $root = strstr($root, '/');
        $controller = $this->request->params['controller'];

        if ($root == "") {
            $site_path = dirname($_SERVER["SCRIPT_NAME"]);
            if ($site_path == '/')
                $site_path = '';
            $pos = strripos($site_path, "webroot");
            $ur = substr($site_path, 0, $pos);
            if (substr($ur, -1) == "/") {
                $root = substr($ur, 0, -1);
            } else {
                $root = $ur;
            }
        }

        echo "<script>var site_path =\"" . $root . "\";</script>";
        ?>
        <?= $this->Html->script('icheck.js') ?>
    </footer>
</body>

</html>