<?php
use Migrations\AbstractMigration;

class CreateTabelaVotacaoChapasMunicipios extends AbstractMigration
{
    /**
     * Change Method.
     *
     * More information on this method is available here:
     * https://book.cakephp.org/phinx/0/en/migrations.html#the-change-method
     * @return void
     */
    public function change()
    {

        if (!$this->hasTable('votacao_chapasmunicipios')) {
            $table = $this->table('votacao_chapasmunicipios');
            
            $table->addColumn('filiado_id', 'integer', ['null' => true, 'comment' => 'ID do Filiado']);
            $table->addColumn('dthora', 'datetime', ['null' => true, 'comment' => 'Data e Hora da votação']);
            $table->addColumn('ip', 'string', ['null' => true, 'comment' => 'IP onde foi realizado a votação', 'limit' => 20]);
            $table->addColumn('chapasmunicipios_id', 'integer', ['null' => true, 'comment' => 'Chapa votada']);
            $table->addColumn('votacao_concluida', 'integer', ['null' => true, 'comment' => '0 - NÃO | 1 - SIM', 'default' => 0]);
            
            $table->create();
        }

    }
}
