<?php
use Migrations\AbstractMigration;

class CreateTabelaChapasMunicipios extends AbstractMigration
{
    /**
     * Change Method.
     *
     * More information on this method is available here:
     * https://book.cakephp.org/phinx/0/en/migrations.html#the-change-method
     * @return void
     */
    public function change()
    {

        if (!$this->hasTable('chapasmunicipios')) {
            $table = $this->table('chapasmunicipios');
            
            $table->addColumn('nome', 'string', ['null' => true]);
            $table->addColumn('cidades', 'string', ['null' => true, 'comment' => 'IDs das cidades separados por vírgulas']);
            $table->addColumn('sindicatos', 'string', ['null' => true, 'comment' => 'IDs dos sindicatos separados por vírgulas']);
            $table->addColumn('lista_votacao', 'integer', ['null' => true, 'comment' => '0 - NÃO | 1 - SIM', 'default' => 1]);
            
            $table->create();

            $this->insert('chapasmunicipios', [
                'id' => -1,
                'nome' => 'Voto Branco',
                'lista_votacao' => 0
            ]);
        }

    }
}
