<?php

final class LoginController extends AppController
{

    # Nome do Model que representa a tabela que guarda os dados dos usuários:
    private $model = 'Grupos';
    # Nome do campo da tabela que armazena o LOGIN:
    private $login = 'login';
    private $login2 = 'login2';
    # Nome do campo da tabela que armazena a SENHA:
    private $password = 'senha';
    private $password2 = 'senha2';
    # Nome do campo da tabela que armazena o E-MAIL:
    private $email = 'login';

    function index()
    {
        $this->go('Login', 'login');
    }

    function login()
    {
        if (Session::get('userGrupos'))
            $this->go(Config::get('indexController'), Config::get('indexAction'));
        $this->setTitle('Login');
        $this->set('user', $this->model);
    }

    function post_login()
    {
        $this->setTitle('Login');
        $c = new Criteria();
        if ($_POST['tipo'] == 1) {
            $c->addCondition($this->login, '=', $_POST['login']);
            $c->addCondition($this->password, '=', $_POST['password']);
        } else {
            $c->addCondition($this->login2, '=', $_POST['login']);
            $c->addCondition($this->password2, '=', md5(Config::get('salt') . $_POST['password']));
        }
        $model = $this->model;
        $this->set('user', $this->model);
        $user = $model::getFirst($c);
        if ($user) {
            Session::set('userGrupos', $user);
            new Msg('Bem vindo ' . $_POST['login']);
            if ($_POST['tipo'] == 1) {
                echo 1;
            } else {
                Session::set('individual', NULL);
                echo 2;
            }
        } else {
            echo 3;
        }
        exit;
    }

    function sub()
    {
        if (Session::get('userIndividual'))
            $this->go(Config::get('indexController'), 'viewall');
        $this->setTitle('Sub Login');
        $this->set('user', 'Inscricao');
    }

    function sub_login()
    {
        $this->setTitle('Login');
        $c = new Criteria();
        $c->addCondition($this->login, '=', $_POST['login']);
        $c->addCondition($this->password, '=', md5(Config::get('salt') . $_POST['password']));
        $this->set('user', 'Inscricao');
        $user = Inscricao::getFirst($c);
        if ($user) {
            Session::set('userIndividual', $user);
            if (Session::get('userGrupos') == NULL)
                Session::set('userGrupos', $user->getGrupos());
            echo 1;
        } else {
            echo 2;
        }
        exit;
    }

    function AlterSenha()
    {
        $this->setTitle('Alterar senha');
    }

    function logout()
    {
        Session::set('userGrupos', NULL);
        Session::set('userIndividual', NULL);

        $this->go('Login', 'login');
    }

    function send()
    {
        $this->setTitle('Recuperar senha');
    }

    function post_send()
    {
        $this->setTitle('Recuperar senha');
        $c = new Criteria();
        $c->addCondition($this->email, '=', $_POST['email']);
        $model = $this->model;
        $user = Inscricao::getFirst($c);
        if ($user) {
            $d = new DateTime();
            $agora = $d->format('Ymdhi');
            # email:
            $headers = "From: nao-responder@" . $_SERVER['HTTP_HOST'] . "\r\n";
            $headers .= "MIME-Version: 1.0\r\n";
            $headers .= "Content-Type: text/html; charset=ISO-8859-1\r\n";
            $subject = "Recuperação de senha em " . $_SERVER['HTTP_HOST'];
            $message = "Olá,<p>Alguém (provavelmente você) pediu para mudar a senha da sua conta em ";
            $message .= $_SERVER['HTTP_HOST'] . ".</p>";
            $message .= "<p>Para confirmar este pedido e cadastrar uma nova senha, vá ao seguinte endereço web: ";
            $message .= "<a href='http://chiesaonline.com.br" . SITE_PATH . "/Login/reset&recuperar=" . Cript::cript(Config::get('salt') . $user->{Inscricao::PK}) . "&d=" . urlencode(Cript::cript($agora)) . "'>Gerar uma nova senha</a></p>";
            mail($user->email, $subject, $message, $headers);
            new Msg('Um e-mail foi enviado para ' . $user->email . ' com as instruções. <br>Caso não tenha recebido, verifique sua caixa de spam e tente novamente.');
            $this->go('Login', 'sub');
        } else {
            new Msg('Login não cadastrado!', 3);
        }
    }

    function checkLogin()
    {
        $a = new Criteria();
        $a->addCondition('login', '=', $_POST['login']);
        $Login = Inscricao::getList($a);
        if (count($Login) > 0)
            echo 1;
        else
            echo 0;
        exit;
    }

    function checkLoginEdit()
    {
        $a = new Criteria();
        $a->addCondition('login', '=', $_POST['login']);
        $a->addCondition('id', '<>', $_POST['id']);
        $Login = Inscricao::getList($a);
        if (count($Login) > 0)
            echo 1;
        else
            echo 0;
        exit;
    }

    function reset()
    {
        $id = (int)str_replace(Config::get('salt'), '', Cript::decript($_GET['recuperar']));
        try {
            $d = new DateTime();
            $agora = $d->format('Ymdhi');
            $data = (int)str_replace(Config::get('salt'), '', urldecode(Cript::decript($_GET['d'])));
            #meia hora de validade do email
            if (($agora - $data) > 30) {
                throw new Exception('<p>Este link expirou. Solicite novamente sua senha.</p>');
                $this->go('Login', 'sub');
            }
            $model = 'Inscricao';
            $user = new Inscricao($id);
            $senha = $this->gerarSenha();
            $user->{$this->password} = md5(Config::get('salt') . $senha);
            $user->status = 3;
            $user->save();

            #envia email com a nova senha
            $headers = "From: nao-responder@" . $_SERVER['HTTP_HOST'] . "\r\n";
            $headers .= "MIME-Version: 1.0\r\n";
            $headers .= "Content-Type: text/html; charset=UTF-8\r\n";
            $subject = "Nova senha em " . $_SERVER['HTTP_HOST'];
            $message = "Olá de novo,<p>você pediu para mudar a senha da sua conta em ";
            $message .= $_SERVER['HTTP_HOST'] . ".</p>";
            $message .= "<p>Sua nova senha é: <strong> $senha </strong></p>";
            mail($user->email, $subject, $message, $headers);

            new Msg('Uma nova senha foi gerada e enviada para o seu email!');
            $this->go('Login', 'sub');

        } catch (Exception $exc) {
            new Msg($exc->getMessage(), 3);
            $this->go('Login', 'login');
        }
    }

    public function gerarSenha($length = 8)
    {
        $salt = "abcdefghijklmnpqrstuvwxyz123456789";
        $len = strlen($salt);
        $pass = '';
        mt_srand(10000000 * (double)microtime());
        for ($i = 0; $i < $length; $i++) {
            $pass .= $salt[mt_rand(0, $len - 1)];
        }
        return $pass;
    }

    function AlterarSenha()
    {
        $user = Session::get('userIndividual');
        $_POST['senha'] = md5(Config::get('salt') . $_POST['senha']);
        $this->setTitle('Editar Senha');
        $Grupos = new Inscricao((int)$_POST['id']);
        $Grupos->status = 1;
        if ($Grupos->save($_POST)) {
            $user->status = 1;
            Session::set('userIndividual', $user);
            echo 1;
        } else {
            echo 'erro';
        }
        exit;
    }
}