<!-- titulo da pagina -->
<div class="row">
    <h1>Trabalhos</h1>
</div>

<div class="row">
    <!-- botao de cadastro -->
    <div class="row text-right pull-right">
        <p><?php echo $this->Html->getLink('<span class="glyphicon glyphicon-plus-sign"></span> Cadastrar Trabalhos', 'Trabalhos', 'add', NULL, array('class' => 'btn btn-primary')); ?></p>
    </div>

    <!-- formulario de pesquisa -->
    <div class="pull-left">
        <form class="form-inline" role="form" method="get" action="<?php echo $this->Html->getUrl(CONTROLLER,ACTION,array('orderBy'=>$this->getParam('orderBy')))?>">
            <input type="hidden" name="m" value="<?php echo CONTROLLER; ?>">
            <input type="hidden" name="p" value="<?php echo ACTION; ?>">
            <div class="form-group">
                <label class="sr-only" for="search">Pesquisar</label>
                <input value="<?php echo $search; ?>" type="search" class="form-control" name="search" id="search" placeholder="Pesquisar titulo">
            </div>
            <button type="submit" class="btn btn-default"><span class="glyphicon glyphicon-search"></span></button>
        </form>
    </div>

</div>
<!-- tabela de resultados -->
<div class="row clearfix">  
    <div class="table-responsive">
        <table class="table table-hover">
            <tr>
                <th>
                    <a href='<?php echo $this->Html->getUrl('Trabalhos', 'all', array('orderBy' => 'titulo', 'search' => $search)); ?>'>
                        titulo
                    </a>
                </th>
                <th>
                    <a href='<?php echo $this->Html->getUrl('Trabalhos', 'all', array('orderBy' => 'resumo', 'search' => $search)); ?>'>
                        resumo
                    </a>
                </th>
                <th>
                    <a href='<?php echo $this->Html->getUrl('Trabalhos', 'all', array('orderBy' => 'url', 'search' => $search)); ?>'>
                        url
                    </a>
                </th>
                <th>
                    <a href='<?php echo $this->Html->getUrl('Trabalhos', 'all', array('orderBy' => 'data', 'search' => $search)); ?>'>
                        data
                    </a>
                </th>
                <th>
                    <a href='<?php echo $this->Html->getUrl('Trabalhos', 'all', array('orderBy' => 'area', 'search' => $search)); ?>'>
                        area
                    </a>
                </th>
                <th>
                    <a href='<?php echo $this->Html->getUrl('Trabalhos', 'all', array('orderBy' => 'idAluno', 'search' => $search)); ?>'>
                        inscricao
                    </a>
                </th>
                <th>
                    <a href='<?php echo $this->Html->getUrl('Trabalhos', 'all', array('orderBy' => 'situacao', 'search' => $search)); ?>'>
                        situacao
                    </a>
                </th>
                <th>&nbsp;</th>
                <th>&nbsp;</th>
            </tr>
            <?php
            foreach ($Trabalhos as $t) {
                echo '<tr>';
                echo '<td>';
                echo $this->Html->getLink($t->titulo, 'Trabalhos', 'view',
                    array('id' => $t->id), // variaveis via GET opcionais
                    array('data-toggle' => 'modal')); // atributos HTML opcionais
                echo '</td>';
                echo '<td>';
                echo $this->Html->getLink($t->resumo, 'Trabalhos', 'view',
                    array('id' => $t->id), // variaveis via GET opcionais
                    array('data-toggle' => 'modal')); // atributos HTML opcionais
                echo '</td>';
                echo '<td>';
                echo $this->Html->getLink($t->url, 'Trabalhos', 'view',
                    array('id' => $t->id), // variaveis via GET opcionais
                    array('data-toggle' => 'modal')); // atributos HTML opcionais
                echo '</td>';
                echo '<td>';
                echo $this->Html->getLink($t->data, 'Trabalhos', 'view',
                    array('id' => $t->id), // variaveis via GET opcionais
                    array('data-toggle' => 'modal')); // atributos HTML opcionais
                echo '</td>';
                echo '<td>';
                echo $this->Html->getLink($t->getArea()->titulo, 'Area', 'view',
                    array('id' => $t->getArea()->id), // variaveis via GET opcionais
                    array('data-toggle' => 'modal')); // atributos HTML opcionais
                echo '</td>';
                echo '<td>';
                echo $this->Html->getLink($t->getInscricao()->nome, 'Inscricao', 'view',
                    array('id' => $t->getInscricao()->id), // variaveis via GET opcionais
                    array('data-toggle' => 'modal')); // atributos HTML opcionais
                echo '</td>';
                echo '<td>';
                echo $this->Html->getLink($t->getSituacao()->situacao, 'Situacao', 'view',
                    array('id' => $t->getSituacao()->id), // variaveis via GET opcionais
                    array('data-toggle' => 'modal')); // atributos HTML opcionais
                echo '</td>';
                echo '<td width="50">';
                echo $this->Html->getLink('<span class="glyphicon glyphicon-edit"></span> ', 'Trabalhos', 'edit', 
                    array('id' => $t->id), 
                    array('class' => 'btn btn-warning btn-sm'));
                echo '</td>';
                echo '<td width="50">';
                echo $this->Html->getLink('<span class="glyphicon glyphicon-remove"></span> ', 'Trabalhos', 'delete', 
                    array('id' => $t->id), 
                    array('class' => 'btn btn-danger btn-sm','data-toggle' => 'modal'));
                echo '</td>';
                echo '</tr>';
            }
            ?>
        </table>

        <!-- menu de paginação -->
        <div style="text-align:center"><?php echo $nav; ?></div>
    </div>
</div>

<script>
    /* faz a pesquisa com ajax */
    $(document).ready(function() {
        $('#search').keyup(function() {
            var r = true;
            if (r) {
                r = false;
                $("div.table-responsive").load(
                <?php
                if (isset($_GET['orderBy']))
                    echo '"' . $this->Html->getUrl('Trabalhos', 'all', array('orderBy' => $_GET['orderBy'])) . '&search=" + encodeURIComponent($("#search").val()) + " .table-responsive"';
                else
                    echo '"' . $this->Html->getUrl('Trabalhos', 'all') . '&search=" + encodeURIComponent($("#search").val()) + " .table-responsive"';
                ?>
                 , function() {
                    r = true;
                });
            }
        });
    });
</script>