<!-- titulo da pagina -->
<div class="row">
    <h1>Palestrante</h1>
</div>

<div class="row">
    <!-- botao de cadastro -->
    <div class="row text-right pull-right">
        <p><?php echo $this->Html->getLink('<span class="glyphicon glyphicon-plus-sign"></span> Cadastrar Palestrante', 'Palestrante', 'add', NULL, array('class' => 'btn btn-primary')); ?></p>
    </div>

    <!-- formulario de pesquisa -->
    <div class="pull-left">
        <form class="form-inline" role="form" method="get" action="<?php echo $this->Html->getUrl(CONTROLLER,ACTION,array('orderBy'=>$this->getParam('orderBy')))?>">
            <input type="hidden" name="m" value="<?php echo CONTROLLER; ?>">
            <input type="hidden" name="p" value="<?php echo ACTION; ?>">
            <div class="form-group">
                <label class="sr-only" for="search">Pesquisar</label>
                <input value="<?php echo $search; ?>" type="search" class="form-control" name="search" id="search" placeholder="Pesquisar por nome">
            </div>
            <button type="submit" class="btn btn-default"><span class="glyphicon glyphicon-search"></span></button>
        </form>
    </div>

</div>
<!-- tabela de resultados -->
<div class="row clearfix">  
    <div class="table-responsive">
        <table class="table table-hover">
            <tr>
                <th>
                    <a href='<?php echo $this->Html->getUrl('Palestrante', 'all', array('orderBy' => 'nome', 'search' => $search)); ?>'>
                        Nome
                    </a>
                </th>
                <th>
                    <a href='<?php echo $this->Html->getUrl('Palestrante', 'all', array('orderBy' => 'imagem', 'search' => $search)); ?>'>
                        Imagem
                    </a>
                </th>
                <th>
                    <a href='<?php echo $this->Html->getUrl('Palestrante', 'all', array('orderBy' => 'descricao', 'search' => $search)); ?>'>
                        Descrição
                    </a>
                </th>
                <th>
                    <a href='<?php echo $this->Html->getUrl('Palestrante', 'all', array('orderBy' => 'situacao', 'search' => $search)); ?>'>
                        Situação
                    </a>
                </th>
                <th>&nbsp;</th>
                <th>&nbsp;</th>
            </tr>
            <?php
            foreach ($Palestrantes as $p) {
                echo '<tr>';
                echo '<td>';
                echo $this->Html->getLink($p->nome, 'Palestrante', 'view',
                    array('id' => $p->id), // variaveis via GET opcionais
                    array('data-toggle' => 'modal')); // atributos HTML opcionais
                echo '</td>';
                echo '<td>';
                echo $this->Html->getLink(($p->imagem !="")? ('<img src="'.SITE_PATH.'/uploads/'.$p->imagem.'" title="'.$p->nome.'" />') : "", 'Palestrante', 'view',
                    array('id' => $p->id), // variaveis via GET opcionais
                    array('data-toggle' => 'modal', 'style'=>'max-width:150px')); // atributos HTML opcionais
                echo '</td>';
                echo '<td>';
                echo $this->Html->getLink(html_entity_decode($p->descricao), 'Palestrante', 'view',
                    array('id' => $p->id), // variaveis via GET opcionais
                    array('data-toggle' => 'modal')); // atributos HTML opcionais
                echo '</td>';
                echo '<td>';
                echo $this->Html->getLink($p->getSituacao()->situacao, 'Situacao', 'view',
                    array('id' => $p->getSituacao()->id), // variaveis via GET opcionais
                    array('data-toggle' => 'modal')); // atributos HTML opcionais
                echo '</td>';
                echo '<td width="50">';
                echo $this->Html->getLink('<span class="glyphicon glyphicon-edit"></span> ', 'Palestrante', 'edit', 
                    array('id' => $p->id), 
                    array('class' => 'btn btn-warning btn-sm'));
                echo '</td>';
                echo '<td width="50">';
                echo $this->Html->getLink('<span class="glyphicon glyphicon-remove"></span> ', 'Palestrante', 'delete', 
                    array('id' => $p->id), 
                    array('class' => 'btn btn-danger btn-sm','data-toggle' => 'modal'));
                echo '</td>';
                echo '</tr>';
            }
            ?>
        </table>

        <!-- menu de paginação -->
        <div style="text-align:center"><?php echo $nav; ?></div>
    </div>
</div>

<script>
    /* faz a pesquisa com ajax */
    $(document).ready(function() {
        $('#search').keyup(function() {
            var r = true;
            if (r) {
                r = false;
                $("div.table-responsive").load(
                <?php
                if (isset($_GET['orderBy']))
                    echo '"' . $this->Html->getUrl('Palestrante', 'all', array('orderBy' => $_GET['orderBy'])) . '&search=" + encodeURIComponent($("#search").val()) + " .table-responsive"';
                else
                    echo '"' . $this->Html->getUrl('Palestrante', 'all') . '&search=" + encodeURIComponent($("#search").val()) + " .table-responsive"';
                ?>
                 , function() {
                    r = true;
                });
            }
        });
    });
</script>