<?php
final class Situacao extends Record{ 

    const TABLE = 'situacao';
    const PK = 'id';
    
    /**
    * Configurações e filtros globais do modelo
    * @return Criteria $criteria
    */
    public static function configure(){
        # $criteria = new Criteria();
        # return $criteria;
    }
    
    /**
    * Situacao possui Areas
    * @return array de Areas
    */
    function getAreas($criteria=NULL) {
        return $this->hasMany('Area','situacao',$criteria);
    }
    
    /**
    * Situacao possui Categoriainscricaos
    * @return array de Categoriainscricaos
    */
    function getCategoriainscricaos($criteria=NULL) {
        return $this->hasMany('Categoriainscricao','situacao',$criteria);
    }
    
    /**
    * Situacao possui Contatos
    * @return array de Contatos
    */
    function getContatos($criteria=NULL) {
        return $this->hasMany('Contato','situacao',$criteria);
    }
    
    /**
    * Situacao possui Correcaotrabalhos
    * @return array de Correcaotrabalhos
    */
    function getCorrecaotrabalhos($criteria=NULL) {
        return $this->hasMany('Correcaotrabalho','situacao',$criteria);
    }
    
    /**
    * Situacao possui Cursos
    * @return array de Cursos
    */
    function getCursos($criteria=NULL) {
        return $this->hasMany('Cursos','situacao',$criteria);
    }
    
    /**
    * Situacao possui Data_programacaos
    * @return array de Data_programacaos
    */
    function getData_programacaos($criteria=NULL) {
        return $this->hasMany('Data_programacao','situacao',$criteria);
    }
    
    /**
    * Situacao possui Grupos
    * @return array de Grupos
    */
    function getGrupos($criteria=NULL) {
        return $this->hasMany('Grupo','situacao',$criteria);
    }
    
    /**
    * Situacao possui Imagenslocais
    * @return array de Imagenslocais
    */
    function getImagenslocais($criteria=NULL) {
        return $this->hasMany('Imagenslocal','situacao',$criteria);
    }
    
    /**
    * Situacao possui Imagensturismos
    * @return array de Imagensturismos
    */
    function getImagensturismos($criteria=NULL) {
        return $this->hasMany('Imagensturismo','situacao',$criteria);
    }
    
    /**
    * Situacao possui Inscricaos
    * @return array de Inscricaos
    */
    function getInscricaos($criteria=NULL) {
        return $this->hasMany('Inscricao','situacao',$criteria);
    }
    
    /**
    * Situacao possui Locais
    * @return array de Locais
    */
    function getLocais($criteria=NULL) {
        return $this->hasMany('Local','situacao',$criteria);
    }
    
    /**
    * Situacao possui Noticias
    * @return array de Noticias
    */
    function getNoticias($criteria=NULL) {
        return $this->hasMany('Noticias','situacao',$criteria);
    }
    
    /**
    * Situacao possui Palestrantes
    * @return array de Palestrantes
    */
    function getPalestrantes($criteria=NULL) {
        return $this->hasMany('Palestrante','situacao',$criteria);
    }
    
    /**
    * Situacao possui Patrocinadores
    * @return array de Patrocinadores
    */
    function getPatrocinadores($criteria=NULL) {
        return $this->hasMany('Patrocinadores','situacao',$criteria);
    }
    
    /**
    * Situacao possui Programacaos
    * @return array de Programacaos
    */
    function getProgramacaos($criteria=NULL) {
        return $this->hasMany('Programacao','situacao',$criteria);
    }
    
    /**
    * Situacao possui Regulamentos
    * @return array de Regulamentos
    */
    function getRegulamentos($criteria=NULL) {
        return $this->hasMany('Regulamento','situacao',$criteria);
    }
    
    /**
    * Situacao possui Situacaotrabalhos
    * @return array de Situacaotrabalhos
    */
    function getSituacaotrabalhos($criteria=NULL) {
        return $this->hasMany('Situacaotrabalho','situacao',$criteria);
    }
    
    /**
    * Situacao possui Sobres
    * @return array de Sobres
    */
    function getSobres($criteria=NULL) {
        return $this->hasMany('Sobre','situacao',$criteria);
    }
    
    /**
    * Situacao possui Tipoeventos
    * @return array de Tipoeventos
    */
    function getTipoeventos($criteria=NULL) {
        return $this->hasMany('Tipoevento','situacao',$criteria);
    }
    
    /**
    * Situacao possui Tipopatrocinadores
    * @return array de Tipopatrocinadores
    */
    function getTipopatrocinadores($criteria=NULL) {
        return $this->hasMany('Tipopatrocinador','situacao',$criteria);
    }
    
    /**
    * Situacao possui Trabalhos
    * @return array de Trabalhos
    */
    function getTrabalhos($criteria=NULL) {
        return $this->hasMany('Trabalhos','situacao',$criteria);
    }
    
    /**
    * Situacao possui Turismos
    * @return array de Turismos
    */
    function getTurismos($criteria=NULL) {
        return $this->hasMany('Turismo','situacao',$criteria);
    }
    
    /**
    * Situacao possui Usuarios
    * @return array de Usuarios
    */
    function getUsuarios($criteria=NULL) {
        return $this->hasMany('Usuarios','situacao',$criteria);
    }
}