<?php
final class Patrocinadores extends Record{ 

    const TABLE = 'patrocinadores';
    const PK = 'id';
    
    /**
    * Configurações e filtros globais do modelo
    * @return Criteria $criteria
    */
    public static function configure(){
        $criteria = new Criteria();
        $criteria->addCondition('situacao','<>',4);
        return $criteria;
    }
    
    /**
    * Patrocinadores pertence a Tipopatrocinador
    * @return Tipopatrocinador $Tipopatrocinador
    */
    function getTipopatrocinador() {
        return $this->belongsTo('Tipopatrocinador','tipoPatrocinador');
    }
    
    /**
    * Patrocinadores pertence a Situacao
    * @return Situacao $Situacao
    */
    function getSituacao() {
        return $this->belongsTo('Situacao','situacao');
    }
}