<?php
final class Local extends Record{ 

    const TABLE = 'local';
    const PK = 'id';
    
    /**
    * Configurações e filtros globais do modelo
    * @return Criteria $criteria
    */
    public static function configure(){
        $criteria = new Criteria();
        $criteria->addCondition('situacao','<>',4);
        return $criteria;
    }
    
    /**
    * Local possui Imagenslocais
    * @return array de Imagenslocais
    */
    function getImagenslocais($criteria=NULL) {
        return $this->hasMany('Imagenslocal','idLocal',$criteria);
    }
    
    /**
    * Local pertence a Situacao
    * @return Situacao $Situacao
    */
    function getSituacao() {
        return $this->belongsTo('Situacao','situacao');
    }
}