<?php
final class Imagenslocal extends Record{ 

    const TABLE = 'imagenslocal';
    const PK = 'id';
    
    /**
    * Configurações e filtros globais do modelo
    * @return Criteria $criteria
    */
    public static function configure(){
        $criteria = new Criteria();
        $criteria->addCondition('situacao','<>',4);
        return $criteria;
    }
    
    /**
    * Imagenslocal pertence a Local
    * @return Local $Local
    */
    function getLocal() {
        return $this->belongsTo('Local','idLocal');
    }
    
    /**
    * Imagenslocal pertence a Situacao
    * @return Situacao $Situacao
    */
    function getSituacao() {
        return $this->belongsTo('Situacao','situacao');
    }
}