<?php
final class Cursos extends Record{ 

    const TABLE = 'cursos';
    const PK = 'id';
    
    /**
    * Configurações e filtros globais do modelo
    * @return Criteria $criteria
    */
    public static function configure(){
        $criteria = new Criteria();
        $criteria->addCondition('situacao','<>',4);
        return $criteria;
    }
    /**
    * Cursos pertence a Situacao
    * @return Situacao $Situacao
    */
    function getSituacao() {
        return $this->belongsTo('Situacao','situacao');
    }

    function getProgramacaos($criteria=NULL) {
        return $this->hasMany('Programacao','curso',$criteria);
    }
}