/**
 * Created by Desenvolvimento on 11/02/2015.
 */
$(function() {
    $( ".datepicker" ).datepicker({
        changeMonth: true,
        changeYear: true
    });
});

$(document).ready(function() {
    $('#cpf').mask('000.000.000-00');
    $('#cep').mask('00000-000');
});

function OpenDialog(titulo,mensagem){
    var div = document.createElement("div");
    div.setAttribute('id', 'dialog-message');
    document.body.appendChild(div);

    function fech(){
        $("#dialog-message").remove();
    }
    $(function() {
        $( "#dialog-message" ).dialog({
            modal: true,
            buttons: {
                Ok: fech
            }
        });
        $( "#dialog-message" ).dialog({ title: titulo });
        $( "#dialog-message" ).dialog({ position: { my: "center", at: "center", of: window } });
        $( "#dialog-message" ).text(mensagem);
    });
}

const myJSONObject = {"navegacao": [{"p": 1, "u": root}]};

function Navegar(url,param){
    var pos = myJSONObject.navegacao.length;
    if(param=='go'){
        pos = pos+1;
        var url = {"p": pos, "u": url};
        myJSONObject.navegacao.push(url);
    }else{
        pos = pos-1;
        myJSONObject.navegacao.pop();
    }

    $.each(myJSONObject,function(key,data){
        $.each(data,function(id,valor){
            if(valor.p==pos) {
                $('.modal').find('.modal-content').load(valor.u);
            }
        });
    });
}

function validarCPF(cpf) {
    cpf = cpf.replace(/[^\d]+/g,'');
    if(cpf == '') return false;
    // Elimina CPFs invalidos conhecidos
    if (cpf.length != 11 ||
        cpf == "00000000000" ||
        cpf == "11111111111" ||
        cpf == "22222222222" ||
        cpf == "33333333333" ||
        cpf == "44444444444" ||
        cpf == "55555555555" ||
        cpf == "66666666666" ||
        cpf == "77777777777" ||
        cpf == "88888888888" ||
        cpf == "99999999999")
        return false;
    // Valida 1o digito
    add = 0;
    for (i=0; i < 9; i ++)
        add += parseInt(cpf.charAt(i)) * (10 - i);
    rev = 11 - (add % 11);
    if (rev == 10 || rev == 11)
        rev = 0;
    if (rev != parseInt(cpf.charAt(9)))
        return false;
    // Valida 2o digito
    add = 0;
    for (i = 0; i < 10; i ++)
        add += parseInt(cpf.charAt(i)) * (11 - i);
    rev = 11 - (add % 11);
    if (rev == 10 || rev == 11)
        rev = 0;
    if (rev != parseInt(cpf.charAt(10)))
        return false;
    return true;
}

function abrirNavegador(dados) {
    var data = dados;
    $("#iFrameRelatorioId").attr("src", data);
    $("#previewAnexo").modal("show");
}

function Acrescentar(url){
    var pos = myJSONObject.navegacao.length;
    pos = pos+1;
    var url = {"p": pos, "u": url};
    myJSONObject.navegacao.push(url);
}


function EnviarFormulario(form){
    $(form).ajaxForm({
        success: function(d){
            if(d!=1){
                $('#msg_error').html(d);
            }else{
                Navegar('','back');
            }
        }
    });
}

function ConfirmarSenha(){
    if($("#senha").val()!= $("#confirmarSenha").val()){
        OpenDialog("Alerta","As senhas não são iguais!!!");
        $("#confirmarSenha").val("");
    }
}


function PaginarPost(pagina){
    $("#formulario").attr("action", root + "/"+$("#m").val()+"/"+$("#p").val()+"/?&page="+pagina);
    $("#formulario").submit();

}