<?php
final class TurismoController extends AppController{ 

    # página inicial do módulo Turismo
    function index(){
        $this->setTitle('Turismo');
    }

    # lista de Turismos
    # renderiza a visão /view/Turismo/all.php
    function all(){
        $this->setTitle('Turismos');
        $p = new Paginate('Turismo', 10);
        $this->set('search', NULL);
        $c = new Criteria();
        if (isset($_GET['search'])) {
            $c->addCondition('titulo', 'LIKE', '%' . $_GET['search'] . '%');
            $this->set('search', $this->getParam('search'));
        }
        if ($this->getParam('orderBy')) {
            $c->setOrder($this->getParam('orderBy'));
        }
        $this->set('Turismos', $p->getPage($c));
        $this->set('nav', $p->getNav());
    }

    # visualiza um(a) Turismo
    # renderiza a visão /view/Turismo/view.php
    function view(){
        try {
            $this->set('Turismo', new Turismo((int)$this->getParam('id')));
        } catch (Exception $e) {
            new Msg($e->getMessage(), 2);
            $this->go('Turismo', 'all');
        }
    }

    # formulário de cadastro de Turismo
    # renderiza a visão /view/Turismo/add.php
    function add(){
        $this->setTitle('Adicionar Turismo');
        $this->set('Turismo', new Turismo);
        $this->set('Situacaos',  Situacao::getList());
    }

    # recebe os dados enviados via post do cadastro de Turismo
    # (true)redireciona ou (false) renderiza a visão /view/Turismo/add.php
    function post_add(){
        $this->setTitle('Adicionar Turismo');
        $Turismo = new Turismo();
        $this->set('Turismo', $Turismo);
        try {
            if($Turismo->save($_POST)){
                $numFile = count(array_filter($_FILES['imagens']['name']));
                if ($numFile > 0) {
                    $arquivos = array(array());
                    foreach ($_FILES as $key => $info) {
                        foreach ($info as $key => $dados) {
                            for ($i = 0; $i < sizeof($dados); $i++) {
                                $arquivos[$i][$key] = $info[$key][$i];
                            }
                        }
                    }
                    foreach ($arquivos as $file) {
                        $ImagemUploader = new ImageUploader($file, 1200);
                        $path = "/turismo/" . $Turismo->id;
                        $nome = time() . $file['name'];
                        if ($ImagemUploader->save($nome, $path)){
                            $imagemTutrismo = new Imagensturismo();
                            $imagemTutrismo->id_turismo = $Turismo->id;
                            $imagemTutrismo->url = $path . "/" . $nome;
                            $imagemTutrismo->situacao = 2;
                            $imagemTutrismo->save();
                        }
                    }
                }
            }
            new Msg(__('Turismo cadastrado com sucesso'));
            $this->go('Turismo', 'all');
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
        }
        $this->set('Situacaos',  Situacao::getList());
    }

    # formulário de edição de Turismo
    # renderiza a visão /view/Turismo/edit.php
    function edit(){
        $this->setTitle('Editar Turismo');
        try {
            $this->set('Turismo', new Turismo((int) $this->getParam('id')));
            $this->set('Situacaos',  Situacao::getList());
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
            $this->go('Turismo', 'all');
        }
    }

    # recebe os dados enviados via post da edição de Turismo
    # (true)redireciona ou (false) renderiza a visão /view/Turismo/edit.php
    function post_edit(){
        $this->setTitle('Editar Turismo');
        try {
            $Turismo = new Turismo((int) $_POST['id']);
            $this->set('Turismo', $Turismo);
            $Turismo->save($_POST);
            new Msg(__('Turismo atualizado com sucesso'));
            $this->go('Turismo', 'all');
        } catch (Exception $e) {
            new Msg(__('Não foi possível atualizar.'), 2);
        }
        $this->set('Situacaos',  Situacao::getList());
    }

    # Confirma a exclusão ou não de um(a) Turismo
    # renderiza a /view/Turismo/delete.php
    function delete(){
        $this->setTitle('Apagar Turismo');
        try {
            $this->set('Turismo', new Turismo((int)$this->getParam('id')));
        } catch (Exception $e) {
            new Msg($e->getMessage(), 2);
            $this->go('Turismo', 'all');
        }
    }

    # Recebe o id via post e exclui um(a) Turismo
    # redireciona para Turismo/all
    function post_delete(){
        try {
            $Turismo = new Turismo((int) $_POST['id']);
            $Turismo->situacao=4;
            $Turismo->save();
            new Msg(__('Turismo apagado com sucesso'), 1);
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
        }
        $this->go('Turismo', 'all');
    }

}