<?php
final class SobreController extends AppController{ 

    # página inicial do módulo Sobre
    function index(){
        $this->setTitle('Sobre');
    }

    # lista de Sobres
    # renderiza a visão /view/Sobre/all.php
    function all(){
        $this->setTitle('Sobres');
        $p = new Paginate('Sobre', 10);
        $this->set('search', NULL);
        $c = new Criteria();
        if (isset($_GET['search'])) {
            $c->addCondition('titulo', 'LIKE', '%' . $_GET['search'] . '%');
            $this->set('search', $this->getParam('search'));
        }
        if ($this->getParam('orderBy')) {
            $c->setOrder($this->getParam('orderBy'));
        }
        $this->set('Sobres', $p->getPage($c));
        $this->set('nav', $p->getNav());
    }

    # visualiza um(a) Sobre
    # renderiza a visão /view/Sobre/view.php
    function view(){
        try {
            $this->set('Sobre', new Sobre((int)$this->getParam('id')));
        } catch (Exception $e) {
            new Msg($e->getMessage(), 2);
            $this->go('Sobre', 'all');
        }
    }

    # formulário de cadastro de Sobre
    # renderiza a visão /view/Sobre/add.php
    function add(){
        $this->setTitle('Adicionar Sobre');
        $this->set('Sobre', new Sobre);
        $this->set('Situacaos',  Situacao::getList());
    }

    # recebe os dados enviados via post do cadastro de Sobre
    # (true)redireciona ou (false) renderiza a visão /view/Sobre/add.php
    function post_add(){
        $this->setTitle('Adicionar Sobre');
        $Sobre = new Sobre();
        $this->set('Sobre', $Sobre);
        try {
            $Sobre->save($_POST);
            new Msg(__('Sobre cadastrado com sucesso'));
            $this->go('Sobre', 'all');
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
        }
        $this->set('Situacaos',  Situacao::getList());
    }

    # formulário de edição de Sobre
    # renderiza a visão /view/Sobre/edit.php
    function edit(){
        $this->setTitle('Editar Sobre');
        try {
            $this->set('Sobre', new Sobre((int) $this->getParam('id')));
            $this->set('Situacaos',  Situacao::getList());
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
            $this->go('Sobre', 'all');
        }
    }

    # recebe os dados enviados via post da edição de Sobre
    # (true)redireciona ou (false) renderiza a visão /view/Sobre/edit.php
    function post_edit(){
        $this->setTitle('Editar Sobre');
        try {
            $Sobre = new Sobre((int) $_POST['id']);
            $this->set('Sobre', $Sobre);
            $Sobre->save($_POST);
            new Msg(__('Sobre atualizado com sucesso'));
            $this->go('Sobre', 'all');
        } catch (Exception $e) {
            new Msg(__('Não foi possível atualizar.'), 2);
        }
        $this->set('Situacaos',  Situacao::getList());
    }

    # Confirma a exclusão ou não de um(a) Sobre
    # renderiza a /view/Sobre/delete.php
    function delete(){
        $this->setTitle('Apagar Sobre');
        try {
            $this->set('Sobre', new Sobre((int)$this->getParam('id')));
        } catch (Exception $e) {
            new Msg($e->getMessage(), 2);
            $this->go('Sobre', 'all');
        }
    }

    # Recebe o id via post e exclui um(a) Sobre
    # redireciona para Sobre/all
    function post_delete(){
        try {
            $Sobre = new Sobre((int) $_POST['id']);
            $Sobre->delete();
            new Msg(__('Sobre apagado com sucesso'), 1);
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
        }
        $this->go('Sobre', 'all');
    }

}