<?php
final class RegulamentoController extends AppController{ 

    # página inicial do módulo Regulamento
    function index(){
        $this->setTitle('Regulamento');
    }

    # lista de Regulamentos
    # renderiza a visão /view/Regulamento/all.php
    function all(){
        $this->setTitle('Regulamentos');
        $p = new Paginate('Regulamento', 10);
        $this->set('search', NULL);
        $c = new Criteria();
        if (isset($_GET['search'])) {
            $c->addCondition('titulo', 'LIKE', '%' . $_GET['search'] . '%');
            $this->set('search', $this->getParam('search'));
        }
        if ($this->getParam('orderBy')) {
            $c->setOrder($this->getParam('orderBy'));
        }
        $this->set('Regulamentos', $p->getPage($c));
        $this->set('nav', $p->getNav());
    }

    # visualiza um(a) Regulamento
    # renderiza a visão /view/Regulamento/view.php
    function view(){
        try {
            $this->set('Regulamento', new Regulamento((int)$this->getParam('id')));
        } catch (Exception $e) {
            new Msg($e->getMessage(), 2);
            $this->go('Regulamento', 'all');
        }
    }

    # formulário de cadastro de Regulamento
    # renderiza a visão /view/Regulamento/add.php
    function add(){
        $this->setTitle('Adicionar Regulamento');
        $this->set('Regulamento', new Regulamento);
        $this->set('Situacaos',  Situacao::getList());
    }

    # recebe os dados enviados via post do cadastro de Regulamento
    # (true)redireciona ou (false) renderiza a visão /view/Regulamento/add.php
    function post_add(){
        $this->setTitle('Adicionar Regulamento');
        $Regulamento = new Regulamento();
        $this->set('Regulamento', $Regulamento);
        try {
            $Regulamento->save($_POST);
            new Msg(__('Regulamento cadastrado com sucesso'));
            $this->go('Regulamento', 'all');
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
        }
        $this->set('Situacaos',  Situacao::getList());
    }

    # formulário de edição de Regulamento
    # renderiza a visão /view/Regulamento/edit.php
    function edit(){
        $this->setTitle('Editar Regulamento');
        try {
            $this->set('Regulamento', new Regulamento((int) $this->getParam('id')));
            $this->set('Situacaos',  Situacao::getList());
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
            $this->go('Regulamento', 'all');
        }
    }

    # recebe os dados enviados via post da edição de Regulamento
    # (true)redireciona ou (false) renderiza a visão /view/Regulamento/edit.php
    function post_edit(){
        $this->setTitle('Editar Regulamento');
        try {
            $Regulamento = new Regulamento((int) $_POST['id']);
            $this->set('Regulamento', $Regulamento);
            $Regulamento->save($_POST);
            new Msg(__('Regulamento atualizado com sucesso'));
            $this->go('Regulamento', 'all');
        } catch (Exception $e) {
            new Msg(__('Não foi possível atualizar.'), 2);
        }
        $this->set('Situacaos',  Situacao::getList());
    }

    # Confirma a exclusão ou não de um(a) Regulamento
    # renderiza a /view/Regulamento/delete.php
    function delete(){
        $this->setTitle('Apagar Regulamento');
        try {
            $this->set('Regulamento', new Regulamento((int)$this->getParam('id')));
        } catch (Exception $e) {
            new Msg($e->getMessage(), 2);
            $this->go('Regulamento', 'all');
        }
    }

    # Recebe o id via post e exclui um(a) Regulamento
    # redireciona para Regulamento/all
    function post_delete(){
        try {
            $Regulamento = new Regulamento((int) $_POST['id']);
            $Regulamento->delete();
            new Msg(__('Regulamento apagado com sucesso'), 1);
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
        }
        $this->go('Regulamento', 'all');
    }

}