<?php
final class ProgramacaoController extends AppController{ 

    # página inicial do módulo Programacao
    function index(){
        $this->setTitle('Programacao');
    }

    # lista de Programacaos
    # renderiza a visão /view/Programacao/all.php
    function all(){
        $this->setTitle('Programacaos');
        $p = new Paginate('Programacao', 10);
        $this->set('search', NULL);
        $c = new Criteria();
        if (isset($_GET['search'])){
            $c->addCondition('titulo', 'LIKE', '%' . $_GET['search'] . '%');
            $this->set('search', $this->getParam('search'));
        }
        if ($this->getParam('orderBy')) {
            $c->setOrder($this->getParam('orderBy'));
        }
        $c->addCondition('situacao','<>',4);
        $this->set('Programacaos', $p->getPage($c));
        $this->set('nav', $p->getNav());
    }

    # visualiza um(a) Programacao
    # renderiza a visão /view/Programacao/view.php
    function view(){
        try {
            $this->set('Programacao', new Programacao((int)$this->getParam('id')));
        } catch (Exception $e) {
            new Msg($e->getMessage(), 2);
            $this->go('Programacao', 'all');
        }
    }

    # formulário de cadastro de Programacao
    # renderiza a visão /view/Programacao/add.php
    function add(){
        $this->setTitle('Adicionar Programacao');
        $this->set('Programacao', new Programacao);
        $c = new Criteria();
        $c->addCondition('situacao','<>',4);
        $this->set('Tipoeventos',  Tipoevento::getList($c));
        $this->set('Situacaos',  Situacao::getList($c));
        $this->set('Data_programacao',  Data_programacao::getList($c));
        $this->set('Palestrante',  Palestrante::getList($c));
    }

    # recebe os dados enviados via post do cadastro de Programacao
    # (true)redireciona ou (false) renderiza a visão /view/Programacao/add.php
    function post_add(){
        $this->setTitle('Adicionar Programacao');
            $Programacao = new Programacao();
            $this->set('Programacao', $Programacao);
            try {
                $Programacao->save($_POST);
                new Msg(__('Programacao cadastrado com sucesso'));
                $this->go('Programacao', 'all');
            } catch (Exception $e) {
                new Msg($e->getMessage(), 3);
            }
            $this->set('Tipoeventos', Tipoevento::getList());
            $this->set('Situacaos', Situacao::getList());
        }

    # formulário de edição de Programacao
    # renderiza a visão /view/Programacao/edit.php
    function edit(){
        $this->setTitle('Editar Programacao');
        try {
            $this->set('Programacao', new Programacao((int) $this->getParam('id')));
            $c = new Criteria();
            $c->addCondition('situacao','<>',4);
            $this->set('Tipoeventos',  Tipoevento::getList($c));
            $this->set('Situacaos',  Situacao::getList($c));
            $this->set('Data_programacao',  Data_programacao::getList($c));
            $this->set('Palestrante',  Palestrante::getList($c));
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
            $this->go('Programacao', 'all');
        }
    }
    # recebe os dados enviados via post da edição de Programacao
    # (true)redireciona ou (false) renderiza a visão /view/Programacao/edit.php
    function post_edit(){
        $this->setTitle('Editar Programacao');
        try {
                $Programacao = new Programacao((int)$_POST['id']);
                $this->set('Programacao', $Programacao);
                $Programacao->save($_POST);
                new Msg(__('Programacao atualizado com sucesso'));
                $this->go('Programacao', 'all');
        } catch (Exception $e) {
            new Msg(__('Não foi possível atualizar.'), 2);
        }
        $this->set('Tipoeventos',  Tipoevento::getList());
        $this->set('Situacaos',  Situacao::getList());
    }
    # Confirma a exclusão ou não de um(a) Programacao
    # renderiza a /view/Programacao/delete.php
    function delete(){
        $this->setTitle('Apagar Programacao');
        try {
            $this->set('Programacao', new Programacao((int)$this->getParam('id')));
        } catch (Exception $e) {
            new Msg($e->getMessage(), 2);
            $this->go('Programacao', 'all');
        }
    }

    # Recebe o id via post e exclui um(a) Programacao
    # redireciona para Programacao/all
    function post_delete(){
        try {
            $Programacao = new Programacao((int) $_POST['id']);
            $Programacao->situacao=4;
            $Programacao->save();
            new Msg(__('Programacao apagado com sucesso'), 1);
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
        }
        $this->go('Programacao', 'all');
    }

}