<?php
final class PalestranteController extends AppController{ 

    # página inicial do módulo Palestrante
    function index(){
        $this->setTitle('Palestrante');
    }

    # lista de Palestrantes
    # renderiza a visão /view/Palestrante/all.php
    function all(){
        $this->setTitle('Palestrantes');
        $p = new Paginate('Palestrante', 10);
        $this->set('search', NULL);
        $c = new Criteria();
        if (isset($_GET['search'])) {
            $c->addCondition('nome', 'LIKE', '%' . $_GET['search'] . '%');
            $this->set('search', $this->getParam('search'));
        }
        if ($this->getParam('orderBy')) {
            $c->setOrder($this->getParam('orderBy'));
        }
        $c->addCondition('situacao','<>',4);
        $this->set('Palestrantes', $p->getPage($c));
        $this->set('nav', $p->getNav());
    }

    # visualiza um(a) Palestrante
    # renderiza a visão /view/Palestrante/view.php
    function view(){
        try {
            $this->set('Palestrante', new Palestrante((int)$this->getParam('id')));
        } catch (Exception $e) {
            new Msg($e->getMessage(), 2);
            $this->go('Palestrante', 'all');
        }
    }

    # formulário de cadastro de Palestrante
    # renderiza a visão /view/Palestrante/add.php
    function add(){
        $this->setTitle('Adicionar Palestrante');
        $this->set('Palestrante', new Palestrante);
        $this->set('Situacaos',  Situacao::getList());
    }

    # recebe os dados enviados via post do cadastro de Palestrante
    # (true)redireciona ou (false) renderiza a visão /view/Palestrante/add.php
    function post_add(){
        $this->setTitle('Adicionar Palestrante');
        $Palestrante = new Palestrante();
        $this->set('Palestrante', $Palestrante);
        try {
            if($Palestrante->save($_POST)){
                if (!empty($_FILES['imagem']['name'])) {
                    $img = $_FILES['imagem'];
                    $Imagem = new ImageUploader($img, 154);
                    $path = "/fotos/" . $Palestrante->id;
                    $nome = time() . $img['name'];
                    if ($Imagem->save($nome, $path)) {
                        $Prog = new Palestrante($Palestrante->id);
                        $Prog->imagem = $path . "/" . $nome;
                        $Prog->save();
                    }
                }
            }
            new Msg(__('Palestrante cadastrado com sucesso'));
            $this->go('Palestrante', 'all');
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
        }
        $this->set('Situacaos',  Situacao::getList());
    }

    # formulário de edição de Palestrante
    # renderiza a visão /view/Palestrante/edit.php
    function edit(){
        $this->setTitle('Editar Palestrante');
        try {
            $this->set('Palestrante', new Palestrante((int) $this->getParam('id')));
            $this->set('Situacaos',  Situacao::getList());
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
            $this->go('Palestrante', 'all');
        }
    }

    # recebe os dados enviados via post da edição de Palestrante
    # (true)redireciona ou (false) renderiza a visão /view/Palestrante/edit.php
    function post_edit(){
        $this->setTitle('Editar Palestrante');
        try {
            $Palestrante = new Palestrante((int) $_POST['id']);
            $this->set('Palestrante', $Palestrante);
            if($Palestrante->save($_POST)){
                if (!empty($_FILES['imagem']['name'])) {
                    $img = $_FILES['imagem'];
                    $Imagem = new ImageUploader($img, 354);
                    $path = "/fotos/" . $_POST['id'];
                    $nome = time() . $img['name'];
                    if ($Imagem->save($nome, $path)) {
                        $Prod = new Palestrante($_POST['id']);
                        $Prod->imagem = $path . "/" . $nome;
                        $Prod->save();
                    }
                }
            }
            new Msg(__('Palestrante atualizado com sucesso'));
            $this->go('Palestrante', 'all');
        } catch (Exception $e) {
            new Msg(__('Não foi possível atualizar.'), 2);
        }
        $this->set('Situacaos',  Situacao::getList());
    }

    # Confirma a exclusão ou não de um(a) Palestrante
    # renderiza a /view/Palestrante/delete.php
    function delete(){
        $this->setTitle('Apagar Palestrante');
        try {
            $this->set('Palestrante', new Palestrante((int)$this->getParam('id')));
        } catch (Exception $e) {
            new Msg($e->getMessage(), 2);
            $this->go('Palestrante', 'all');
        }
    }

    # Recebe o id via post e exclui um(a) Palestrante
    # redireciona para Palestrante/all
    function post_delete(){
        try {
            $Palestrante = new Palestrante((int) $_POST['id']);
            $Palestrante->situacao=4;
            $Palestrante->save();
            new Msg(__('Palestrante apagado com sucesso'), 1);
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
        }
        $this->go('Palestrante', 'all');
    }

}