<?php
final class NoticiasController extends AppController{ 

    # página inicial do módulo Noticias
    function index(){
        $this->setTitle('Noticias');
    }

    # lista de Noticias
    # renderiza a visão /view/Noticias/all.php
    function all(){
        $this->setTitle('Noticias');
        $p = new Paginate('Noticias', 10);
        $this->set('search', NULL);
        $c = new Criteria();
        if (isset($_GET['search'])) {
            $c->addCondition('titulo', 'LIKE', '%' . $_GET['search'] . '%');
            $this->set('search', $this->getParam('search'));
        }
        if ($this->getParam('orderBy')) {
            $c->setOrder($this->getParam('orderBy'));
        }
        $this->set('Noticias', $p->getPage($c));
        $this->set('nav', $p->getNav());
    }

    # visualiza um(a) Noticias
    # renderiza a visão /view/Noticias/view.php
    function view(){
        try {
            $this->set('Noticias', new Noticias((int)$this->getParam('id')));
        } catch (Exception $e) {
            new Msg($e->getMessage(), 2);
            $this->go('Noticias', 'all');
        }
    }

    # formulário de cadastro de Noticias
    # renderiza a visão /view/Noticias/add.php
    function add(){
        $this->setTitle('Adicionar Noticias');
        $this->set('Noticias', new Noticias);
        $this->set('Situacaos',  Situacao::getList());
    }

    # recebe os dados enviados via post do cadastro de Noticias
    # (true)redireciona ou (false) renderiza a visão /view/Noticias/add.php
    function post_add(){
        $this->setTitle('Adicionar Noticias');
        $Noticias = new Noticias();
        $this->set('Noticias', $Noticias);
        try {
            $Noticias->save($_POST);
            new Msg(__('Noticias cadastrado com sucesso'));
            $this->go('Noticias', 'all');
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
        }
        $this->set('Situacaos',  Situacao::getList());
    }

    # formulário de edição de Noticias
    # renderiza a visão /view/Noticias/edit.php
    function edit(){
        $this->setTitle('Editar Noticias');
        try {
            $this->set('Noticias', new Noticias((int) $this->getParam('id')));
            $this->set('Situacaos',  Situacao::getList());
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
            $this->go('Noticias', 'all');
        }
    }

    # recebe os dados enviados via post da edição de Noticias
    # (true)redireciona ou (false) renderiza a visão /view/Noticias/edit.php
    function post_edit(){
        $this->setTitle('Editar Noticias');
        try {
            $Noticias = new Noticias((int) $_POST['id']);
            $this->set('Noticias', $Noticias);
            $Noticias->save($_POST);
            new Msg(__('Noticias atualizado com sucesso'));
            $this->go('Noticias', 'all');
        } catch (Exception $e) {
            new Msg(__('Não foi possível atualizar.'), 2);
        }
        $this->set('Situacaos',  Situacao::getList());
    }

    # Confirma a exclusão ou não de um(a) Noticias
    # renderiza a /view/Noticias/delete.php
    function delete(){
        $this->setTitle('Apagar Noticias');
        try {
            $this->set('Noticias', new Noticias((int)$this->getParam('id')));
        } catch (Exception $e) {
            new Msg($e->getMessage(), 2);
            $this->go('Noticias', 'all');
        }
    }

    # Recebe o id via post e exclui um(a) Noticias
    # redireciona para Noticias/all
    function post_delete(){
        try {
            $Noticias = new Noticias((int) $_POST['id']);
            $Noticias->situacao=4;
            $Noticias->save();
            new Msg(__('Noticias apagado com sucesso'), 1);
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
        }
        $this->go('Noticias', 'all');
    }

}