<?php

final class InscricaoController extends AppController
{

    # página inicial do módulo Inscricao
    function index()
    {
        $this->setTitle('Inscricao');
    }

    # lista de Inscricaos
    # renderiza a visão /view/Inscricao/all.php
    function all()
    {
        $this->setTitle('Inscricaos');
        $p = new Paginate('Inscricao', 10);
        $this->set('search', NULL);
        $c = new Criteria();
        if (isset($_GET['search'])) {
            $c->addCondition('nome', 'LIKE', '%' . $_GET['search'] . '%');
            $this->set('search', $this->getParam('search'));
        }
        if ($this->getParam('grupo')) {
            $c->addCondition('grupo', '=', $this->getParam('grupo'));
            $this->set('grupo', $this->getParam('grupo'));
        }
        if (!empty($_GET['nome'])) {
            $c->addCondition('nome', 'LIKE', '%' . $_GET['nome'] . '%');
        }
        if (!empty($_GET['inscricao'])) {
            $c->addCondition('id', '=', $_GET['inscricao']);
        }

        if ($this->getParam('orderBy')) {
            $c->setOrder($this->getParam('orderBy'));
        }
        $c->setOrder('nome');
        $this->set('Inscricaos', $p->getPage($c));
        $this->set('nav', $p->getNav());
    }

    # visualiza um(a) Inscricao
    # renderiza a visão /view/Inscricao/view.php
    function view()
    {
        try {
            $this->set('Inscricao', new Inscricao((int)$this->getParam('id')));
        } catch (Exception $e) {
            new Msg($e->getMessage(), 2);
            $this->go('Inscricao', 'all');
        }
    }

    # formulário de cadastro de Inscricao
    # renderiza a visão /view/Inscricao/add.php
    function add()
    {
        if ($this->getParam('grupo')) {
            $this->set('grupo', $this->getParam('grupo'));
        }
        $this->setTitle('Adicionar Inscricao');
        $this->set('Inscricao', new Inscricao);
        $this->set('FormaPagamento', Formapg::getList());
        $this->set('Situacaos', Situacao::getList());
        $this->set('Categoriainscricaos', Categoriainscricao::getList());
    }

    # recebe os dados enviados via post do cadastro de Inscricao
    # (true)redireciona ou (false) renderiza a visão /view/Inscricao/add.php
    function post_add()
    {
        $this->setTitle('Adicionar Inscricao');
        $Inscricao = new Inscricao();
        $this->set('Inscricao', $Inscricao);
        try {
            if (!empty($_FILES['anexo']['name'])) {
                $extencoes = array('jpg', 'pdf', 'gif', 'odf', 'docx', 'doc', 'txt', 'png');
                $File = new FileUploader($_FILES['anexo'], NULL, $extencoes);
                $nome = uniqid() . $_FILES['anexo']['name'];
                $path = "arquivos/" . $_POST['grupo'];
                $File->save($nome, $path);
                $_POST['anexo'] = SITE_PATH . "/uploads/" . $path . '/' . $nome;
            }
            $user = Session::get('user');
            $_POST['datahora_inscricao'] = date('Y-m-d H:i:s');
            $_POST['quem_cadastro'] = $user->id;

//            $_POST['senha'] = md5(Config::get('salt').$_POST['senha']);
            if ($Inscricao->save($_POST)) {
                $grupo = new Grupos((int)$_POST['grupo']);
                $grupo->qtdeInscritos = $grupo->qtdeInscritos + 1;
                $grupo->save();
            }

//            $this->EnviarEmail($Inscricao->email,$Inscricao->email_alternativo,$Inscricao->nome,$Inscricao->login,$senha);

            if (!empty($_POST['modal'])) {
                echo 1;
                exit;
            }
            new Msg(__('Inscrição cadastrada com sucesso'));
            $this->go('Inscricao', 'all');
        } catch (Exception $e) {
            new Msg($e->getMessage(), 3);
        }
        $this->set('Situacaos', Situacao::getList());
        $this->set('Categoriainscricaos', Categoriainscricao::getList());
    }

    # formulário de edição de Inscricao
    # renderiza a visão /view/Inscricao/edit.php
    function edit()
    {
        $this->setTitle('Editar Inscricao');
        try {
            if ($this->getParam('grupo')) {
                $this->set('grupo', $this->getParam('grupo'));
            }
            $this->set('FormaPagamento', Formapg::getList());
            $this->set('Inscricao', new Inscricao((int)$this->getParam('id')));
            $this->set('Situacaos', Situacao::getList());
            $this->set('Categoriainscricaos', Categoriainscricao::getList());
        } catch (Exception $e) {
            new Msg($e->getMessage(), 3);
            $this->go('Inscricao', 'all');
        }
    }

    function ativar()
    {
        $this->setTitle("Ativar Inscrito");
        $this->set('FormaPagamento', Formapg::getList());
        $this->set('Inscricao', new Inscricao((int)$this->getParam('id')));
    }

    function desativar()
    {
        $this->setTitle("Desativar Inscrito");
        $this->set('Inscricao', new Inscricao((int)$this->getParam('id')));
    }

    function post_ativar()
    {
        $this->setTitle("Ativar Inscrito");
        try {
            $Inscricao = new Inscricao((int)$_POST['id']);
            $v = str_replace('.', '', $_POST['valor']);
            $z = str_replace(',', '.', $v);
            $_POST['valor'] = number_format($z, 2, '.', '');
            $Inscricao->situacao = 2;
            $Inscricao->formapg = $_POST['formapg'];
            $Inscricao->valor = $_POST['valor'];
            $Inscricao->save();
            new Msg(__('Inscricao ativada com sucesso'));
            if (!empty($_POST['modal'])) {
                echo 1;
                exit;
            }
            $this->go('Inscricao', 'all');
        } catch (Exception $e) {
            new Msg($e->getMessage(), 3);
            $this->go('Inscricao', 'all');
        }
    }

    function post_desativar()
    {
        $this->setTitle("Desativar Inscrito");
        try {
            $Inscricao = new Inscricao((int)$_POST['id']);
            $Inscricao->situacao = 1;
            $Inscricao->save();
            new Msg(__('Inscricao desativada com sucesso'));
            if (!empty($_POST['modal'])) {
                echo 1;
                exit;
            }
            $this->go('Inscricao', 'all');
        } catch (Exception $e) {
            new Msg($e->getMessage(), 3);
            $this->go('Inscricao', 'all');
        }
    }
    # recebe os dados enviados via post da edição de Inscricao
    # (true)redireciona ou (false) renderiza a visão /view/Inscricao/edit.php
    function post_edit()
    {
        $this->setTitle('Editar Inscricao');
        try {
            $Inscricao = new Inscricao((int)$_POST['id']);
            if (!empty($_FILES['anexo']['name'])) {
                $extencoes = array('jpg', 'pdf', 'gif', 'odf', 'docx', 'doc', 'txt', 'png');
                $File = new FileUploader($_FILES['anexo'], NULL, $extencoes);
                $nome = uniqid() . $_FILES['anexo']['name'];
                $path = "arquivos/" . $_POST['grupo'];
                $File->save($nome, $path);
                $_POST['anexo'] = SITE_PATH . "/uploads/" . $path . '/' . $nome;
            }
            $user = Session::get('user');
            $_POST['ultima_data'] = date('Y-m-d H:i:s');
            $_POST['ultimo_id'] = $user->id;

            $this->set('Inscricao', $Inscricao);
            $Inscricao->save($_POST);

            if (!empty($_POST['modal'])) {
                echo 1;
                exit;
            }
            new Msg(__('Inscricao atualizado com sucesso'));
            $this->go('Inscricao', 'all');
        } catch (Exception $e) {
            new Msg(__('Não foi possível atualizar.'), 2);
        }
        $this->set('Situacaos', Situacao::getList());
        $this->set('Categoriainscricaos', Categoriainscricao::getList());
    }

    # Confirma a exclusão ou não de um(a) Inscricao
    # renderiza a /view/Inscricao/delete.php
    function delete()
    {
        $this->setTitle('Apagar Inscricao');
        try {
            $this->set('Inscricao', new Inscricao((int)$this->getParam('id')));
        } catch (Exception $e) {
            new Msg($e->getMessage(), 2);
            $this->go('Inscricao', 'all');
        }
    }

    # Recebe o id via post e exclui um(a) Inscricao
    # redireciona para Inscricao/all
    function post_delete()
    {
        try {
            $Inscricao = new Inscricao((int)$_POST['id']);
            $Inscricao->situacao = 3;
            if ($Inscricao->save()) {
                if ($Inscricao->save($_POST)) {
                    $grupo = new Grupos((int)$_POST['grupo']);
                    $grupo->qtdeInscritos = $grupo->qtdeInscritos - 1;
                    $grupo->save();
                }
            }
            if (!empty($_POST['modal'])) {
                echo 1;
                exit;
            }
            new Msg(__('Inscricao apagado com sucesso'), 1);
        } catch (Exception $e) {
            new Msg($e->getMessage(), 3);
        }
        $this->go('Inscricao', 'all');
    }

    function cep()
    {
        $cep = $_POST['cep'];
        $url = "http://cep.republicavirtual.com.br/web_cep.php?formato=xml&cep=" . $cep;
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_URL, $url);
        $aux = curl_exec($ch);
        curl_close($ch);
        $dados = simplexml_load_string($aux);
        echo $dados->resultado . "," . $dados->logradouro . "," . $dados->bairro . "," . $dados->cidade . "," . $dados->uf;
        exit();
    }


    function EnviarEmail($email, $email_alternativo, $nome, $login, $senha)
    {
        $mail = new PHPMailer();
        $mail->IsSMTP(); // Define que a mensagem será SMTP
        $mail->Host = "vps.chiesaonline.com.br";
        $mail->SMTPAuth = true;
        $mail->Username = 'contato@chiesaonline.com.br';
        $mail->Password = 'chiesa6990';
        $mail->From = "contato@chiesaonline.com.br";
        $mail->FromName = "Chiesa Advogados Associados";

        $mail->AddAddress($email, $nome);
        $mail->AddAddress("contato@chiesaonline.com.br", 'Copia Cadastro do ' . $nome);
        $mail->AddAddress($email_alternativo, 'Copia Cadastro do ' . $nome);

        $mail->IsHTML(true);
        $mail->CharSet = 'UTF-8';
//          Texto e Assunto
        $mail->Subject = "Cadastro no Congresso"; // Assunto da mensagem
        $mail->Body = '<table>';
        $mail->Body .= '<tr>';
        $mail->Body = '<td colspan="3"><IMG src="http://chiesaonline.com.br/congresso/template/ucdb/img/logo.png" alt="Congresso Direito Tributário" class="wp-smiley" style="margin-bottom: 20px"><td>';
        $mail->Body .= '</tr>';
        $mail->Body .= '<tr>';
        $mail->Body .= '<td colspan="3"><br /><p><strong>Ol&aacute; ' . $nome . '!</strong></p></td>';
        $mail->Body .= '</tr>';
        $mail->Body .= '<tr>';
        $mail->Body .= '<td colspan="3"><p>Seu cadastro no XII Congresso de Direito Tributário foi realizado com sucesso! <br /> Segue abaixo os dados de acesso ao seu painel:</p></td>';
        $mail->Body .= '</tr>';
        $mail->Body .= '<tr>';
        $mail->Body .= '<td colspan="3"><p>Link: <strong>http://chiesaonline.com.br/congresso/grupos/Login/sub/</strong></p></td>';
        $mail->Body .= '<td colspan="3"><p>Login: <strong>' . $login . '</strong><br />Senha: <strong>' . $senha . '</strong></p></td>';
        $mail->Body .= '</tr>';
        $mail->Body .= '</table>';
//            Anexos (opcional)
//            $mail->AddAttachment("e:\home\login\web\documento.pdf", "novo_nome.pdf");

        $enviado = $mail->Send();
//            Limpa os destinatários e os anexos
        $mail->ClearAllRecipients();
        $mail->ClearAttachments();
    }

    function certificado()
    {
        $this->setTitle('Emitir certificado');
        $this->set('Grupo', new Grupos($this->getParam('grupo')));
        $this->set('Inscricao', new Inscricao($this->getParam('id')));

    }

    function search()
    {
        $nome = (!empty($_POST['nome'])) ? $_POST['nome'] : "";
        $id = (!empty($_POST['inscricao'])) ? $_POST['inscricao'] : "";

        $c = new Criteria();
        if ($nome != "") {
            $c->addCondition('nome', 'like', $nome . '%');
            $this->set('nome', $nome);
        }
        if ($id != "") {
            $c->addCondition('id', '=', $id);
            $this->set('inscricao', $id);
        }
        $Inscricao = Inscricao::getList($c);
        $ids = array();
        foreach ($Inscricao as $i) {
            $ids[] = $i->getGrupos()->id;
        }
        echo json_encode($ids);
        exit;
    }

    function imprimir()
    {
        $Inscricao = new Inscricao((int)$_POST['id']);
        $Inscricao->certificadoemitido = date('Y-m-d H:i:s');
        $Inscricao->impressa = 1;
        if ($Inscricao->save()) {
            echo 1;
        } else {
            echo 'erro';
        }
        exit;
    }

    function excelcamisetas()
    {

        header('Content-Encoding: UTF-8');
        header('Content-type: text/csv; charset=UTF-8');
        header('Content-Description: File Transfer');
        header('Content-Disposition: attachment; filename="relacao_camisetas.csv"');
        header('Content-Transfer-Encoding: binary');
        header('Expires: 0');
        header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
        header('Pragma: public');

        $csvFile = fopen('php://output', 'w+');

        $sql = "SELECT * FROM relacao_camisetas ORDER BY descricao ASC,nome ASC";
        $db = $this::getConn();
        $db->query($sql);
        $db->execute();
        $dados = $db->fetchAll(PDO::FETCH_ASSOC);

        //força o excel usar a codificaçao utf8 NÃO APAGAR
        fputs($csvFile, "\xEF\xBB\xBF");

        $headerTamanhos = array('Grupo','PP', 'P', 'M', 'G','GG','XG','XXG','Total por Grupo');
        fputcsv($csvFile, $headerTamanhos, ';');
        $totaisPorCamisetas =  array('PP'=>0, 'P'=>0, 'M'=>0, 'G'=>0,'GG'=>0,'XG'=>0,'XXG'=>0);
        $camisetas = array('PP'=>0, 'P'=>0, 'M'=>0, 'G'=>0,'GG'=>0,'XG'=>0,'XXG'=>0);
        if (isset($dados)) {
            $totais = array();
            foreach ($dados as $key => $value) {
                if (!isset($totais[$value['descricao']])) {
                    $totais[$value['descricao']] = $camisetas;
                }
                $totais[$value['descricao']][$value['tamanho_camiseta']] += 1;
                $totaisPorCamisetas[$value['tamanho_camiseta']] += 1;
            }


            foreach ($totais AS $key => $value) {
                $result = array($key);
                $resultMerge = array_merge($result, $value);
                $resultMerge['total'] = array_sum($value);
                fputcsv($csvFile, $resultMerge, ';');
            }


            $headerTotais = array('Total de Camisetas :');
            $totaisPorCamisetas['total'] = array_sum($totaisPorCamisetas);
            $rowTotal = array_merge($headerTotais, $totaisPorCamisetas);
            fputcsv($csvFile, $rowTotal, ';');
            fputcsv($csvFile, array(' '), ';');

            $header = array('Nome', 'Sexo', 'Grupo', 'Tamanho','Assinatura');
            fputcsv($csvFile, $header, ';');
            foreach ($dados as $key => $value) {
                unset($value['inscricao_id']);
                unset($value['grupos_id']);
                fputcsv($csvFile, $value, ';');
            }
        }

        fclose($csvFile);
        exit();
    }
}