<?php
final class ImagensturismoController extends AppController{ 

    # página inicial do módulo Imagensturismo
    function index(){
        $this->setTitle('Imagensturismo');
    }

    # lista de Imagensturismos
    # renderiza a visão /view/Imagensturismo/all.php
    function all(){
        $this->setTitle('Imagensturismos');
        $p = new Paginate('Imagensturismo', 10);
        $this->set('search', NULL);
        $c = new Criteria();
        if (isset($_GET['search'])) {
            $c->addCondition('url', 'LIKE', '%' . $_GET['search'] . '%');
            $this->set('search', $this->getParam('search'));
        }
        if ($this->getParam('orderBy')) {
            $c->setOrder($this->getParam('orderBy'));
        }
        $this->set('Imagensturismos', $p->getPage($c));
        $this->set('nav', $p->getNav());
    }

    # visualiza um(a) Imagensturismo
    # renderiza a visão /view/Imagensturismo/view.php
    function view(){
        try {
            $this->set('Imagensturismo', new Imagensturismo((int)$this->getParam('id')));
        } catch (Exception $e) {
            new Msg($e->getMessage(), 2);
            $this->go('Imagensturismo', 'all');
        }
    }

    # formulário de cadastro de Imagensturismo
    # renderiza a visão /view/Imagensturismo/add.php
    function add(){
        $this->setTitle('Adicionar Imagensturismo');
        $this->set('Imagensturismo', new Imagensturismo);
        $this->set('Turismos',  Turismo::getList());
        $this->set('Situacaos',  Situacao::getList());
    }

    # recebe os dados enviados via post do cadastro de Imagensturismo
    # (true)redireciona ou (false) renderiza a visão /view/Imagensturismo/add.php
    function post_add(){
        $this->setTitle('Adicionar Imagensturismo');
        try {
            $numFile = count(array_filter($_FILES['imagens']['name']));
            if ($numFile > 0) {
                $arquivos = array(array());
                foreach ($_FILES as $key => $info) {
                    foreach ($info as $key => $dados) {
                        for ($i = 0; $i < sizeof($dados); $i++) {
                            $arquivos[$i][$key] = $info[$key][$i];
                        }
                    }
                }
                foreach ($arquivos as $file) {
                    $ImagemUploader = new ImageUploader($file, 1200);
                    $path = "/turismo/" . $_POST['id_turismo'];
                    $nome = time() . $file['name'];
                    if ($ImagemUploader->save($nome, $path)){
                        $Imagensturismo = new Imagensturismo();
                        $this->set('Imagensturismo', $Imagensturismo);
                        $Imagensturismo ->id_turismo = $_POST['id_turismo'];
                        $Imagensturismo ->url = $path . "/" . $nome;
                        $Imagensturismo ->situacao = 2;
                        $Imagensturismo ->save();
                    }
                }
                new Msg(__('Imagens cadastradas com sucesso'));
                $this->go('Imagensturismo', 'all');
            }else{
                new Msg('Selecione pelo menos uma imagem',3);
                $this->go('Imagensturismo', 'all');
            }
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
        }
        $this->set('Turismos',  Turismo::getList());
        $this->set('Situacaos',  Situacao::getList());
    }

    # formulário de edição de Imagensturismo
    # renderiza a visão /view/Imagensturismo/edit.php
    function edit(){
        $this->setTitle('Editar Imagensturismo');
        try {
            $this->set('Imagensturismo', new Imagensturismo((int) $this->getParam('id')));
            $this->set('Turismos',  Turismo::getList());
            $this->set('Situacaos',  Situacao::getList());
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
            $this->go('Imagensturismo', 'all');
        }
    }

    # recebe os dados enviados via post da edição de Imagensturismo
    # (true)redireciona ou (false) renderiza a visão /view/Imagensturismo/edit.php
    function post_edit(){
        $this->setTitle('Editar Imagensturismo');
        try {
            $Imagensturismo = new Imagensturismo((int) $_POST['id']);
            $this->set('Imagensturismo', $Imagensturismo);
            $Imagensturismo->save($_POST);
            new Msg(__('Imagensturismo atualizado com sucesso'));
            $this->go('Imagensturismo', 'all');
        } catch (Exception $e) {
            new Msg(__('Não foi possível atualizar.'), 2);
        }
        $this->set('Turismos',  Turismo::getList());
        $this->set('Situacaos',  Situacao::getList());
    }

    # Confirma a exclusão ou não de um(a) Imagensturismo
    # renderiza a /view/Imagensturismo/delete.php
    function delete(){
        $this->setTitle('Apagar Imagensturismo');
        try {
            $this->set('Imagensturismo', new Imagensturismo((int)$this->getParam('id')));
        } catch (Exception $e) {
            new Msg($e->getMessage(), 2);
            $this->go('Imagensturismo', 'all');
        }
    }

    # Recebe o id via post e exclui um(a) Imagensturismo
    # redireciona para Imagensturismo/all
    function post_delete(){
        try {
            $Imagensturismo = new Imagensturismo((int) $_POST['id']);
            $Imagensturismo->delete();
            new Msg(__('Imagensturismo apagado com sucesso'), 1);
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
        }
        $this->go('Imagensturismo', 'all');
    }

}