<?php
final class ImagensprogramacaoController extends AppController{ 

    # página inicial do módulo Imagensprogramacao
    function index(){
        $this->setTitle('Imagensprogramacao');
    }

    # lista de Imagensprogramacaos
    # renderiza a visão /view/Imagensprogramacao/all.php
    function all(){
        $this->setTitle('Imagensprogramacaos');
        $p = new Paginate('Imagensprogramacao', 10);
        $this->set('search', NULL);
        $c = new Criteria();
        if (isset($_GET['search'])) {
            $c->addCondition('url', 'LIKE', '%' . $_GET['search'] . '%');
            $this->set('search', $this->getParam('search'));
        }
        if ($this->getParam('orderBy')) {
            $c->setOrder($this->getParam('orderBy'));
        }
        $this->set('Imagensprogramacaos', $p->getPage($c));
        $this->set('nav', $p->getNav());
    }

    # visualiza um(a) Imagensprogramacao
    # renderiza a visão /view/Imagensprogramacao/view.php
    function view(){
        try {
            $this->set('Imagensprogramacao', new Imagensprogramacao((int)$this->getParam('id')));
        } catch (Exception $e) {
            new Msg($e->getMessage(), 2);
            $this->go('Imagensprogramacao', 'all');
        }
    }

    # formulário de cadastro de Imagensprogramacao
    # renderiza a visão /view/Imagensprogramacao/add.php
    function add(){
        $this->setTitle('Adicionar Imagensprogramacao');
        $this->set('Imagensprogramacao', new Imagensprogramacao);
        $this->set('Programacaos',  Programacao::getList());
        $this->set('Situacaos',  Situacao::getList());
    }

    # recebe os dados enviados via post do cadastro de Imagensprogramacao
    # (true)redireciona ou (false) renderiza a visão /view/Imagensprogramacao/add.php
    function post_add(){
        $this->setTitle('Adicionar Imagensprogramacao');
        $Imagensprogramacao = new Imagensprogramacao();
        $this->set('Imagensprogramacao', $Imagensprogramacao);
        try {
            $Imagensprogramacao->save($_POST);
            new Msg(__('Imagensprogramacao cadastrado com sucesso'));
            $this->go('Imagensprogramacao', 'all');
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
        }
        $this->set('Programacaos',  Programacao::getList());
        $this->set('Situacaos',  Situacao::getList());
    }

    # formulário de edição de Imagensprogramacao
    # renderiza a visão /view/Imagensprogramacao/edit.php
    function edit(){
        $this->setTitle('Editar Imagensprogramacao');
        try {
            $this->set('Imagensprogramacao', new Imagensprogramacao((int) $this->getParam('id')));
            $this->set('Programacaos',  Programacao::getList());
            $this->set('Situacaos',  Situacao::getList());
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
            $this->go('Imagensprogramacao', 'all');
        }
    }

    # recebe os dados enviados via post da edição de Imagensprogramacao
    # (true)redireciona ou (false) renderiza a visão /view/Imagensprogramacao/edit.php
    function post_edit(){
        $this->setTitle('Editar Imagensprogramacao');
        try {
            $Imagensprogramacao = new Imagensprogramacao((int) $_POST['id']);
            $this->set('Imagensprogramacao', $Imagensprogramacao);
            $Imagensprogramacao->save($_POST);
            new Msg(__('Imagensprogramacao atualizado com sucesso'));
            $this->go('Imagensprogramacao', 'all');
        } catch (Exception $e) {
            new Msg(__('Não foi possível atualizar.'), 2);
        }
        $this->set('Programacaos',  Programacao::getList());
        $this->set('Situacaos',  Situacao::getList());
    }

    # Confirma a exclusão ou não de um(a) Imagensprogramacao
    # renderiza a /view/Imagensprogramacao/delete.php
    function delete(){
        $this->setTitle('Apagar Imagensprogramacao');
        try {
            $this->set('Imagensprogramacao', new Imagensprogramacao((int)$this->getParam('id')));
        } catch (Exception $e) {
            new Msg($e->getMessage(), 2);
            $this->go('Imagensprogramacao', 'all');
        }
    }

    # Recebe o id via post e exclui um(a) Imagensprogramacao
    # redireciona para Imagensprogramacao/all
    function post_delete(){
        try {
            $Imagensprogramacao = new Imagensprogramacao((int) $_POST['id']);
            $Imagensprogramacao->delete();
            new Msg(__('Imagensprogramacao apagado com sucesso'), 1);
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
        }
        $this->go('Imagensprogramacao', 'all');
    }

}