<?php
final class GruposController extends AppController{ 

    # página inicial do módulo Grupos
    function index(){
        $this->setTitle('Grupos');
    }

    # lista de Grupos
    # renderiza a visão /view/Grupos/all.php
    function all(){
        $this->setTitle('Grupos');
        $p = new Paginate('Grupos', 10);
        $this->set('grupos', NULL);
        $this->set('nome', NULL);
        $this->set('inscricao', NULL);
        $c = new Criteria();

        if (!empty($_POST['grupos'])) {
            $c->addCondition('id', '=',  $_POST['grupos']);
            $this->set('grupos', $this->getParam('grupos'));
        }
        if ($this->getParam('orderBy')) {
            $c->setOrder($this->getParam('orderBy'));
        }

        if(isset($_GET['ids'])){
            $this->set('nome',$_GET['nome']);
            $this->set('inscricao',$_GET['inscricao']);
            $grupos = explode(',',$_GET['ids']);
            $gs = array_unique($grupos);
            $aux = 1;
            if($gs) {
                foreach ($gs as $d) {
                    if ($aux > 1)
                        $c->addOr();
                    $c->addCondition('id', '=', $d);
                    $aux = 2;
                }
            }
        }

        $a = new Criteria();
        $a->addCondition('situacao','=',1);
        $this->set('Groups',Grupos::getList($a));

        $c->addCondition('situacao','=',1);
        $this->set('Grupos', $p->getPage($c));
        $this->set('nav', $p->getNav());
    }

    # visualiza um(a) Grupos
    # renderiza a visão /view/Grupos/view.php
    function view(){
        try {
            $this->set('Grupos', new Grupos((int)$this->getParam('id')));
        } catch (Exception $e) {
            new Msg($e->getMessage(), 2);
            $this->go('Grupos', 'all');
        }
    }

    # formulário de cadastro de Grupos
    # renderiza a visão /view/Grupos/add.php
    function add(){
        $this->setTitle('Adicionar Grupos');
        $this->set('Grupos', new Grupos);
    }

    # recebe os dados enviados via post do cadastro de Grupos
    # (true)redireciona ou (false) renderiza a visão /view/Grupos/add.php
    function post_add(){
        $this->setTitle('Adicionar Grupos');
        $Grupos = new Grupos();
        $this->set('Grupos', $Grupos);
        try {
            if(!empty($_FILES['anexo']['name'])) {
                $extencoes = array('jpg', 'pdf', 'gif', 'odf', 'docx', 'doc', 'txt', 'png');
                $File = new FileUploader($_FILES['anexo'], NULL, $extencoes);
                $nome = uniqid() . $_FILES['anexo']['name'];
                $path = "arquivos/grupos/" . $_POST['grupo'];
                $File->save($nome, $path);
                $_POST['anexo'] = SITE_PATH . "/uploads/" . $path . $nome;
            }
            if(!empty($_POST['valorCobrado'])) {
                $v = str_replace('.', '', $_POST['valorCobrado']);
                $z = str_replace(',', '.', $v);
                $_POST['valorCobrado'] = number_format($z, 2, '.', '');
            }
//            $_POST['senha'] = md5(Config::get('salt').$_POST['senha']);

            $Grupos->save($_POST);
            new Msg(__('Grupos cadastrado com sucesso'));
            $this->go('Grupos', 'all');
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
        }
    }

    # formulário de edição de Grupos
    # renderiza a visão /view/Grupos/edit.php
    function edit(){
        $this->setTitle('Editar Grupos');
        try {
            $this->set('Grupos', new Grupos((int) $this->getParam('id')));
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
            $this->go('Grupos', 'all');
        }
    }

    # recebe os dados enviados via post da edição de Grupos
    # (true)redireciona ou (false) renderiza a visão /view/Grupos/edit.php
    function post_edit(){
        $this->setTitle('Editar Grupos');
        try {
            $Grupos = new Grupos((int) $_POST['id']);

            $this->set('Grupos', $Grupos);
            /*if(!empty($_POST['senha'])) {
                $_POST['senha'] = md5(Config::get('salt') . $_POST['senha']);
            }*/

            $Grupos->save($_POST);
            new Msg(__('Grupos atualizado com sucesso'));
            $this->go('Grupos', 'all');
        } catch (Exception $e) {
            new Msg(__('Não foi possível atualizar.'), 2);
        }
    }

    # Confirma a exclusão ou não de um(a) Grupos
    # renderiza a /view/Grupos/delete.php
    function delete(){
        $this->setTitle('Apagar Grupos');
        try {
            $this->set('Grupos', new Grupos((int)$this->getParam('id')));
        } catch (Exception $e) {
            new Msg($e->getMessage(), 2);
            $this->go('Grupos', 'all');
        }
    }

    # Recebe o id via post e exclui um(a) Grupos
    # redireciona para Grupos/all
    function post_delete(){
        try {
            $Grupos = new Grupos((int) $_POST['id']);
            $Grupos->situacao=3;
            $Grupos->save();
            new Msg(__('Grupos apagado com sucesso'), 1);
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
        }
        $this->go('Grupos', 'all');
    }

    function relatorio(){
        $this->setTitle('Relatórios de Grupos');
        $a = new Criteria();
        $a->setOrder('descricao');
        $grupos =Grupos::getList($a);
        $html="";
        $aux="";
        $tgeral=0;
        $tgpre=0;
        $tgef=0;
        $tgtitular=0;
        $tgsuplente=0;
        $rgroup=0;
        foreach ($grupos as $g) {
            $html.="<div class='col-md-6'> <h4>$g->descricao</h4></div>";
            //$html.="<div class='col-md-6'> <h4>Valor do Grupo: R$ ".number_format($g->valorCobrado,2,',','.')." </h4></div>";
            if($g->observacao!="")
                $html.="<div class='col-md-12'>Observação: ".$g->observacao."</div>";

            $rgroup=$rgroup+$g->valorCobrado;
            $inscricao =$this->query("SELECT IF(I.situacao=2,'pre','Ativo') AS total_pre,COUNT(I.id) AS total,I.tipo AS tipo
                            FROM inscricao I
                            LEFT JOIN situacao S
                            ON S.`id` = I.`situacao`
                            WHERE I.`situacao`<= 2 AND I.`grupo` = ".$g->id."
                            GROUP BY total_pre,tipo ORDER BY S.`situacao` DESC");
            $html.="<table class='table table-hover'>
            <tr>
            <th><div class='col-md-5'> &nbsp;</div></th>
                <th >
                        Pré-Inscrição
                </th>
                <th>
                        Efetivado
                </th>
                <th>
                        Titular
                </th>
                <th>
                        Suplente
                </th>
                <th>
                        Total
                </th>
            </tr>
        ";
            if($inscricao) {
                $totalpre=0;
                $totalTitular=0;
                $totalSuplente=0;
                $totalat=0;
                foreach ($inscricao as $i) {
                    $soma=0;
                    $html.="<tr>";
                    $html.="<td><div class='col-md-5'> &nbsp;</div></td>";
                    if ($i->total_pre == 'pre') {
                        $html .= "<td>" . $i->total . "</td>";
                        $soma = $soma + $i->total;
                        $totalpre=$totalpre+$i->total;
                    } else {
                        $html .= "<td>0</td>";
                    }
                    if ($i->total_pre == 'Ativo') {
                        $html .= "<td>" . $i->total . "</td>";
                        $soma = $soma + $i->total;
                        $totalat=$totalat+$i->total;
                    } else {
                        $html .= "<td>0</td>";
                    }

                    if ($i->tipo == 'Titular') {
                        $html .= "<td>" . $i->total . "</td>";
                        //$soma = $soma + $i->total;
                        $totalTitular=$totalTitular+$i->total;
                    } else {
                        $html .= "<td>0</td>";
                    }
                    if ($i->tipo == 'Suplente') {
                        $html .= "<td>" . $i->total . "</td>";
//                        $soma = $soma + $i->total;
                        $totalSuplente=$totalSuplente+$i->total;
                    } else {
                        $html .= "<td>0</td>";
                    }
                    $html .= "<td>" . $soma . "</td>";
                    $html.="</tr>";
                }
                $tgeral=$tgeral+($totalpre+$totalat);
                $tgpre=$tgpre+$totalpre;
                $tgef=$tgef+$totalat;
                $tgtitular=$tgtitular+$totalTitular;
                $tgsuplente=$tgsuplente+$totalSuplente;

                $html.="<tr><td></td>";
                        $html.="<td>".$totalpre."</td>";
                        $html.="<td>".$totalat."</td>";
                        $html.="<td>".$totalTitular."</td>";
                        $html.="<td>".$totalSuplente."</td>";
                        $html.="<td>".($totalpre+$totalat)."</td>";
                $html.="</tr>";
            }else{
                $html.="<td colspan='4'></td>";
            }
            $html.="</table>";
        }
//        $html.="<div class='col-md-3 '><h3>Valor: R$ ".number_format($rgroup,2,',','.')."</h3></div>";
        $html.="<div class='col-md-2 text-right'><h4>Pré- Inscritos: ".$tgpre."</h4></div>";
        $html.="<div class='col-md-3 text-right'><h4>Efetivados: ".$tgef."</h4></div>";
        $html.="<div class='col-md-2 text-right'><h4>Titular: ".$tgtitular."</h4></div>";
        $html.="<div class='col-md-2 text-right'><h4>Suplente: ".$tgsuplente."</h4></div>";
        $html.="<div class='col-md-2 text-right '><h4>Total: ".$tgeral."</h4></div>";

        $this->set('html',$html);
    }

    function relatorio_detalhes(){
        $this->setTitle('Relatórios de Grupos');
        $a = new Criteria();
        $a->setOrder('descricao');
        $this->set('grupos',Grupos::getList($a));
    }


}