<?php
final class CursosController extends AppController{ 

    # página inicial do módulo Cursos
    function index(){
        $this->setTitle('Cursos');
    }

    # lista de Cursos
    # renderiza a visão /view/Cursos/all.php
    function all(){
        $this->setTitle('Cursos');
        $p = new Paginate('Cursos', 10);
        $this->set('search', NULL);
        $c = new Criteria();
        if (isset($_GET['search'])) {
            $c->addCondition('titulo', 'LIKE', '%' . $_GET['search'] . '%');
            $this->set('search', $this->getParam('search'));
        }
        if ($this->getParam('orderBy')) {
            $c->setOrder($this->getParam('orderBy'));
        }
        $c->addCondition('situacao','<>',4);
        $this->set('Cursos', $p->getPage($c));
        $this->set('nav', $p->getNav());
    }

    # visualiza um(a) Cursos
    # renderiza a visão /view/Cursos/view.php
    function view(){
        try {
            $this->set('Cursos', new Cursos((int)$this->getParam('id')));
        } catch (Exception $e) {
            new Msg($e->getMessage(), 2);
            $this->go('Cursos', 'all');
        }
    }

    # formulário de cadastro de Cursos
    # renderiza a visão /view/Cursos/add.php
    function add(){
        $this->setTitle('Adicionar Cursos');
        $this->set('Cursos', new Cursos);
        $this->set('Situacaos',  Situacao::getList());
    }

    # recebe os dados enviados via post do cadastro de Cursos
    # (true)redireciona ou (false) renderiza a visão /view/Cursos/add.php
    function post_add(){
        $this->setTitle('Adicionar Cursos');
        $Cursos = new Cursos();
        $this->set('Cursos', $Cursos);
        try {
            $Cursos->save($_POST);
            new Msg(__('Cursos cadastrado com sucesso'));
            $this->go('Cursos', 'all');
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
        }
        $this->set('Situacaos',  Situacao::getList());
    }

    # formulário de edição de Cursos
    # renderiza a visão /view/Cursos/edit.php
    function edit(){
        $this->setTitle('Editar Cursos');
        try {
            $this->set('Cursos', new Cursos((int) $this->getParam('id')));
            $this->set('Situacaos',  Situacao::getList());
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
            $this->go('Cursos', 'all');
        }
    }

    # recebe os dados enviados via post da edição de Cursos
    # (true)redireciona ou (false) renderiza a visão /view/Cursos/edit.php
    function post_edit(){
        $this->setTitle('Editar Cursos');
        try {
            $Cursos = new Cursos((int) $_POST['id']);
            $this->set('Cursos', $Cursos);
            $Cursos->save($_POST);
            new Msg(__('Cursos atualizado com sucesso'));
            $this->go('Cursos', 'all');
        } catch (Exception $e) {
            new Msg(__('Não foi possível atualizar.'), 2);
        }
        $this->set('Situacaos',  Situacao::getList());
    }

    # Confirma a exclusão ou não de um(a) Cursos
    # renderiza a /view/Cursos/delete.php
    function delete(){
        $this->setTitle('Apagar Cursos');
        try {
            $this->set('Cursos', new Cursos((int)$this->getParam('id')));
        } catch (Exception $e) {
            new Msg($e->getMessage(), 2);
            $this->go('Cursos', 'all');
        }
    }

    # Recebe o id via post e exclui um(a) Cursos
    # redireciona para Cursos/all
    function post_delete(){
        try {
            $Cursos = new Cursos((int) $_POST['id']);
            $Cursos->situacao=4;
            $Cursos->save();
            new Msg(__('Cursos apagado com sucesso'), 1);
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
        }
        $this->go('Cursos', 'all');
    }

}