<?php
final class CategoriainscricaoController extends AppController{ 

    # página inicial do módulo Categoriainscricao
    function index(){
        $this->setTitle('Categoriainscricao');
    }

    # lista de Categoriainscricaos
    # renderiza a visão /view/Categoriainscricao/all.php
    function all(){
        $this->setTitle('Categoriainscricaos');
        $p = new Paginate('Categoriainscricao', 10);
        $this->set('search', NULL);
        $c = new Criteria();
        if (isset($_GET['search'])) {
            $c->addCondition('titulo', 'LIKE', '%' . $_GET['search'] . '%');
            $this->set('search', $this->getParam('search'));
        }
        if ($this->getParam('orderBy')) {
            $c->setOrder($this->getParam('orderBy'));
        }
        $this->set('Categoriainscricaos', $p->getPage($c));
        $this->set('nav', $p->getNav());
    }

    # visualiza um(a) Categoriainscricao
    # renderiza a visão /view/Categoriainscricao/view.php
    function view(){
        try {
            $this->set('Categoriainscricao', new Categoriainscricao((int)$this->getParam('id')));
        } catch (Exception $e) {
            new Msg($e->getMessage(), 2);
            $this->go('Categoriainscricao', 'all');
        }
    }

    # formulário de cadastro de Categoriainscricao
    # renderiza a visão /view/Categoriainscricao/add.php
    function add(){
        $this->setTitle('Adicionar Categoriainscricao');
        $this->set('Categoriainscricao', new Categoriainscricao);
        $this->set('Situacaos',  Situacao::getList());
    }

    # recebe os dados enviados via post do cadastro de Categoriainscricao
    # (true)redireciona ou (false) renderiza a visão /view/Categoriainscricao/add.php
    function post_add(){
        $this->setTitle('Adicionar Categoriainscricao');
        $Categoriainscricao = new Categoriainscricao();
        $this->set('Categoriainscricao', $Categoriainscricao);
        try {
            $Categoriainscricao->save($_POST);
            new Msg(__('Categoriainscricao cadastrado com sucesso'));
            $this->go('Categoriainscricao', 'all');
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
        }
        $this->set('Situacaos',  Situacao::getList());
    }

    # formulário de edição de Categoriainscricao
    # renderiza a visão /view/Categoriainscricao/edit.php
    function edit(){
        $this->setTitle('Editar Categoriainscricao');
        try {
            $this->set('Categoriainscricao', new Categoriainscricao((int) $this->getParam('id')));
            $this->set('Situacaos',  Situacao::getList());
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
            $this->go('Categoriainscricao', 'all');
        }
    }

    # recebe os dados enviados via post da edição de Categoriainscricao
    # (true)redireciona ou (false) renderiza a visão /view/Categoriainscricao/edit.php
    function post_edit(){
        $this->setTitle('Editar Categoriainscricao');
        try {
            $Categoriainscricao = new Categoriainscricao((int) $_POST['id']);
            $this->set('Categoriainscricao', $Categoriainscricao);
            $Categoriainscricao->save($_POST);
            new Msg(__('Categoriainscricao atualizado com sucesso'));
            $this->go('Categoriainscricao', 'all');
        } catch (Exception $e) {
            new Msg(__('Não foi possível atualizar.'), 2);
        }
        $this->set('Situacaos',  Situacao::getList());
    }

    # Confirma a exclusão ou não de um(a) Categoriainscricao
    # renderiza a /view/Categoriainscricao/delete.php
    function delete(){
        $this->setTitle('Apagar Categoriainscricao');
        try {
            $this->set('Categoriainscricao', new Categoriainscricao((int)$this->getParam('id')));
        } catch (Exception $e) {
            new Msg($e->getMessage(), 2);
            $this->go('Categoriainscricao', 'all');
        }
    }

    # Recebe o id via post e exclui um(a) Categoriainscricao
    # redireciona para Categoriainscricao/all
    function post_delete(){
        try {
            $Categoriainscricao = new Categoriainscricao((int) $_POST['id']);
            $Categoriainscricao->delete();
            new Msg(__('Categoriainscricao apagado com sucesso'), 1);
        } catch (Exception $e) {
            new Msg($e->getMessage(),3);
        }
        $this->go('Categoriainscricao', 'all');
    }

}