function mascaraDataNascimento(campoData) {
    let isBackSpace = window.event.keyCode == 8 ? true : false

    if (campoData.value.length == 2 && !isBackSpace)
        campoData.value += "/";

    if (campoData.value.length == 5 && !isBackSpace)
        campoData.value += "/";
}

function mascaraTelefone(campoTelefone) {
    let telefone = campoTelefone.value;
    let isBackSpace = window.event.keyCode == 8 ? true : false

    if (!isBackSpace) {
        if (telefone.length == 1)
            campoTelefone.value = '(' + telefone;

        if (telefone.length == 3)
            campoTelefone.value = telefone + ') ';

        if (telefone.length == 6)
            campoTelefone.value = telefone + ' ';

        if (telefone.length == 11)
            campoTelefone.value = telefone + '-';
    }
}

function validaCPF(element) {
    let cpf = $("#cpf").val();
    if (cpf.length != 11) {
        toastInfo("CPF Inválido! Verifique-o e tente novamente.");
        return false;
    } else {
        let numeros = cpf.substring(0, 9);
        let digitos = cpf.substring(9);
        let soma = 0;

        for (let i = 10; i > 1; i--) {
            soma += numeros.charAt(10 - i) * i;
        }

        let resultado = soma % 11 < 2 ? 0 : 11 - (soma % 11);

        if (resultado != digitos.charAt(0)) {
            toastInfo("CPF Inválido! Verifique-o e tente novamente.");
            return false;
        }

        soma = 0;
        numeros = cpf.substring(0, 10);

        for (let k = 11; k > 1; k--) {
            soma += numeros.charAt(11 - k) * k;
        }
        resultado = soma % 11 < 2 ? 0 : 11 - (soma % 11);

        /**Validando o primeiro digito */

        if (resultado != digitos.charAt(1)) {
            toastInfo("CPF Inválido! Verifique-o e tente novamente.");
            return false;
        }

        if (validationForm(element.closest('form')))
            element.closest('form').submit();

    }/** Fim da instrução else */
}

const validationForm = function (form) {
    let validate = true;
    form.find("input, select, textarea").each(function (index, value) {
        if ($(this).attr("required")) {
            var form_group = $(value).closest(".form-group");
            var label = form_group.find("label").text();
            if (
                $(value).val() == ""
                || $(value).val() == null
                && ($(value).attr("id") != "telefone"
                    && $(value).attr("id") != "dtnascimento")
            ) {
                validate = false;
                $(this).css('background-color', 'pink');
                toastInfo(`O campo ${$(value).data('idValidador').toUpperCase()} não está preenchido!`);
                return false;
            }
        }
    });
    return validate;
};

async function toastInfo(msg, status = "ERRO", image_status = "cancel.svg") {
    $('img.rounded').attr('src', `${site_path}/img/${image_status}`);
    $(".me-auto").text(status);
    $(".toast-body").text(msg);
    $("#liveToast").addClass("show");
    $("#liveToast").removeClass("hide");
    $("#liveToast").removeClass("fade");
    await setTimeout(() => {
        $("#liveToast").removeClass("show");
        $("#liveToast").addClass("hide");
    }, 3000);
}

function fillSindicato() {
    id = $('#cidade-id').val();

    $.ajax({
        method: 'GET',
        url: `${site_path}/sindicato/fill/${id}`,
        dataType: 'JSON',
        success: (response) => {
            let options = transformarJsonInOptions(response.dados);
            $('#sindicato-id').html(options);
        }
    });
}

function transformarJsonInOptions(data, chave = "id", valor = "text") {
    let options = "<option>Selecione</option>";

    $.each(data, function (key, obj) {
        let disabled = obj.disabled ? 'disabled' : '';
        options += `<option ${disabled} value='${obj[chave]}'> ${obj[valor]} </option> `;
    })

    return options;
}

$(document).ready(function () {
    $('input:checkbox').iCheck({
        checkboxClass: 'icheckbox_flat-green',
        radioClass: 'iradio_flat-green',
        increaseArea: '20%' // optional
    });

    $('.chapa-fetems').on('ifChecked', function(){
        
        let elementoChecadoId = $(this).attr('id');
        
        $('.chapa-fetems').each(function() {
 
            if($(this).attr('id') != elementoChecadoId){
                
                $(this).iCheck('uncheck');
            }
            
        });        

    });

    $('.chapa-regionais').on('ifChecked', function(){
        
        let elementoChecadoId = $(this).attr('id');
        
        $('.chapa-regionais').each(function() {
 
            if($(this).attr('id') != elementoChecadoId){
                
                $(this).iCheck('uncheck');
            }
            
        });        

    });

    $('.chapa-municipios').on('ifChecked', function(){
        
        let elementoChecadoId = $(this).attr('id');
        
        $('.chapa-municipios').each(function() {
 
            if($(this).attr('id') != elementoChecadoId){
                
                $(this).iCheck('uncheck');
            }
            
        });        

    });

    $("input").each(function (index, value) {
        $(this).on('keypress', function(){
            $(this).css('background-color', 'white');
        })
    });
    
    $("select").each(function (index, value) {
        $(this).on('change', function(){
            $(this).css('background-color', 'white');
        })
    });
});

async function voto(element, usuario_id, chapa_local, cidade = 0){
    let chapa_selecionada = '';
    $('.nextBtn').attr('disabled',true);
    $(`.${chapa_local}`).parent().each(function(){
        if($(this).hasClass("checked")){
            chapa_selecionada = $(this).children()[0].value;
        } else {
            chapa_selecionada = $(this).children()[0].value * -1;
        }
    });
    
    await $.ajax({
        method: 'POST',
        url: `${site_path}/${element.data('controller')}/add/${usuario_id}/${chapa_selecionada}`,
        beforeSend: function (xhr) {
            xhr.setRequestHeader('X-CSRF-Token', $('[name="_csrfToken"]').val());
        },
        success: function (response) {
            if(!response.dentro_periodo){
                location.href = `${site_path}/${response.controller}/${response.action}`;
            }
            toastInfo(response.msg, (response.exists ? 'ERRO' : 'SUCESSO'), (response.exists ? 'cancel.svg' : 'success.svg'));
            setTimeout(() => {
                let action = `${response.controller == 'filiado' ? 'votacao-concluida' : 'add'}`
                if(action == 'add'){
                    action=+`/${usuario_id}`
                }
                location.href = `${site_path}/${response.controller}/${action}`;
            }, 3500)
        },
    });

}