<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Filiado $filiado
 */
?>
<div class="filiado view">
<fieldset>
        <legend class="pb-3">CPF: <?= h($filiado->cpf) ?></legend>    
        <table class="vertical-table">
            <tr>
                <th scope="row"><?= __('Nome') ?></th>
                <td class="w-100"><?= h($filiado->nome) ?></td>
            </tr>
            </tr>
            <tr>
                <th scope="row"><?= __('Cidade') ?></th>
                <td class="w-100"><?= $filiado->cidade->nome ?></td>
            </tr>
            <tr>
                <th scope="row"><?= __('Sindicato') ?></th>
                <td class="w-100"><?= $filiado->sindicato->nome ?></td>
            </tr>
        </table>
    </fieldset>
    <?php if(!$filiado->votou):?>
        <?= $this->Html->link('Confirmar os dados e iniciar a votação', '/votacao-fetems/add/'.$filiadoUrl, ['class' => 'float-end btn btn-primary']) ?>
    <?php else:?>
        <div class="alert alert-warning" role="alert">
            <?= 'Voto já realizado em '.date('d/m/Y', strtotime($filiado->votou_dthora)).' as '.date('H:i:s', strtotime($filiado->votou_dthora)).' no IP '.$ip ?>
        </div>
        <?= $this->Form->button('Voltar para Página Inicial', ['class' => 'start-50 translate-middle mt-4', 'onclick' => "location.href = '/votacao'"]) ?>
    <?php endif; ?>
</div>
