<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Chapasregionais Model
 *
 * @method \App\Model\Entity\Chapasregionai get($primaryKey, $options = [])
 * @method \App\Model\Entity\Chapasregionai newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Chapasregionai[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Chapasregionai|false save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Chapasregionai saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Chapasregionai patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Chapasregionai[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Chapasregionai findOrCreate($search, callable $callback = null, $options = [])
 */
class ChapasregionaisTable extends Table
{
    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('chapasregionais');
        $this->setDisplayField('nome');
        $this->setPrimaryKey('id');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmptyString('id', null, 'create');

        $validator
            ->scalar('nome')
            ->maxLength('nome', 255)
            ->allowEmptyString('nome');

        $validator
            ->scalar('cidades')
            ->maxLength('cidades', 255)
            ->allowEmptyString('cidades');

        $validator
            ->scalar('sindicatos')
            ->maxLength('sindicatos', 255)
            ->allowEmptyString('sindicatos');

        $validator
            ->integer('lista_votacao')
            ->allowEmptyString('lista_votacao');

        return $validator;
    }
}
