<?php

namespace App\Controller;

use App\Controller\AppController;
use Cake\Datasource\ConnectionManager;
use PDOException;

/**
 * VotacaoChapasmunicipios Controller
 *
 * @property \App\Model\Table\VotacaoChapasmunicipiosTable $VotacaoChapasmunicipios
 *
 * @method \App\Model\Entity\VotacaoChapasmunicipio[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class VotacaoChapasmunicipiosController extends AppController
{
    public $components = ['Filtros'];

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null Redirects on successful add, renders view otherwise.
     */
    public function add($usuario_id = null, $chapa_municipio_selecionada = null)
    {

        $this->loadModel('Filiado');
        $this->loadModel('Chapasmunicipios');
        $this->loadModel('Configuracao');

        $config = $this->Configuracao->buscarDataHoraVotacao();
        if (!$config->periodo_votacao) {
            $this->viewBuilder()->layout('ajax');
            $this->autoRender = false;
            $res = ['controller' => 'filiado', 'action' => 'error', 'dentro_periodo' => false];
            return $this->response->withType('json')->withStringBody(json_encode($res));
        }

        $connection = ConnectionManager::get('default');

        $this->Filiado->setConnection($connection);
        $this->Chapasmunicipios->setConnection($connection);

        $connection->begin();

        try {
            if (empty($this->request->getSession()->read('filiado'))) {
                throw new PDOException('Sessão expirada ou não foi iniciada! Por favor faça login.', 0);
            }

            $filiado_votou_todos = $this->Filiado->filiadoVotouDthoraIp($usuario_id, 'VotacaoChapasmunicipios');
            if (!empty($filiado) && $filiado->votou == 1) {
                throw new PDOException('Seus votos já foi realizado em ' . date('d/m/Y', strtotime($filiado_votou_todos->votou_dthora)) . ' as ' . date('H:i:s', strtotime($filiado_votou_todos->votou_dthora)) . ' pelo IP ' . $filiado_votou_todos->votacao_fetems->ip, 1);
            }

            $cidade_id = $this->Filiado->getCidadeId($usuario_id);
            if (empty($cidade_id)) {
                throw new PDOException('Filiado não encontrado no sistema. Por favor, faça login.', 1);
            }

            if ($cidade_id == 75) {
                $chapasMunicipios = $this->Chapasmunicipios
                    ->find('all')
                    ->where(['lista_votacao' => 1]);
                $chapasmunicipios = $this->Filtros->arrayChavesEstrangeirasCidade($chapasMunicipios, $cidade_id);
            }

            $votacaoChapasmunicipio = $this->VotacaoChapasmunicipios->newEntity();
            if ($this->request->is('post')) {
                $this->viewBuilder()->layout('ajax');
                $this->autoRender = false;
                $res = ['msg' => 'Voto Municipal realizado com sucesso', 'exists' => false, 'controller' => 'filiado', 'dentro_periodo' => true];

                $usuario_id = json_decode(base64_decode($usuario_id))->id;
                if ($this->VotacaoChapasmunicipios->find('list')->where(['filiado_id' => $usuario_id])->toArray() != []) {
                    $res['msg'] = 'Este item já foi votado! Não é possível refazer o voto.';
                    $res['exists'] = true;
                    return $this->response->withType('json')->withStringBody(json_encode($res));
                }

                $votacaoChapasmunicipio = $this->VotacaoChapasmunicipios->patchEntity($votacaoChapasmunicipio, $this->request->getData());
                $votacaoChapasmunicipio->filiado_id = intval($usuario_id);
                $votacaoChapasmunicipio->chapasmunicipios_id = (int) $chapa_municipio_selecionada;
                $votacaoChapasmunicipio->dthora = date('Y-m-d H:i:s');
                $votacaoChapasmunicipio->votacao_concluida = 1;
                $votacaoChapasmunicipio->ip = $_SERVER['REMOTE_ADDR'];
                if (!$this->VotacaoChapasmunicipios->save($votacaoChapasmunicipio)) {
                    throw new PDOException('Falha ao salvar votação FETEMS');
                }
                $connection->commit();
                return $this->response->withType('json')->withStringBody(json_encode($res));
            }
        } catch (PDOException $e) {
            $connection->rollback();

            $usuario = '';

            if ($e->getCode() == 0) {
                $controller = 'filiado';
                $action = 'index';
            } else if ($e->getCode() == 1) {
                $controller = '/';
                $action = 'index';
            }

            $this->Flash->error(__($e->getMessage()));
            $this->redirect(['controller' => $controller, 'action' => $action, $usuario]);
        }

        $this->set(compact('chapasmunicipios', 'cidade_id', 'usuario_id'));
    }
}
